/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.free.OverslimeModifier;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final ValidatedResult AT_CAPACITY = ValidatedResult.failure(Util.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private static final Lazy<ModifierEntry> RESULT = Lazy.of(() -> new ModifierEntry((Modifier)TinkerModifiers.overslime.get(), 1));
    private static final Lazy<List<ItemStack>> DISPLAY_TOOLS = Lazy.of(() -> IDisplayModifierRecipe.getAllModifiable().map(MAP_TOOL_FOR_RENDERING).collect(Collectors.toList()));
    private List<List<ItemStack>> displayItems = null;

    public OverslimeModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
        ModifierRecipeLookup.addIngredient(ingredient);
        ModifierRecipeLookup.setUpgradeSlots((Modifier)TinkerModifiers.overslime.get(), 0);
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)inv.getTinkerableStack().func_77973_b())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int cap = overslime.getCapacity(tool);
        if (tool.getUpgrades().getLevel((Modifier)TinkerModifiers.overslime.get()) == 0) {
            if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) > 0 && (current = overslime.getOverslime(tool)) >= cap) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier((Modifier)TinkerModifiers.overslime.get(), 1);
            cap = overslime.getCapacity(tool);
        } else {
            current = overslime.getOverslime(tool);
            if (current >= cap) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        overslime.setOverslime(tool, Math.min(current + available, cap));
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) != 0) {
            current = overslime.getOverslime(tool);
        }
        int maxNeeded = overslime.getOverslime(ToolStack.from(result)) - current;
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount, ItemStack.field_190927_a);
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    public List<List<ItemStack>> getDisplayItems() {
        if (this.displayItems == null) {
            CompoundNBT volatileNBT = new CompoundNBT();
            ModDataNBT volatileData = ModDataNBT.readFromNBT(volatileNBT);
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            overslime.setCapacity(volatileData, 500);
            CompoundNBT persistentNBT = new CompoundNBT();
            overslime.setOverslime(ModDataNBT.readFromNBT(persistentNBT), this.restoreAmount);
            List displayOutputs = IDisplayModifierRecipe.getAllModifiable().map(MAP_TOOL_FOR_RENDERING).map(stack -> {
                ItemStack result = IDisplayModifierRecipe.withModifiers(stack, null, (ModifierEntry)RESULT.get());
                CompoundNBT nbt = result.func_196082_o();
                nbt.func_218657_a("tic_volatile_data", (INBT)volatileNBT);
                nbt.func_218657_a("tic_persistent_data", (INBT)persistentNBT);
                return result;
            }).collect(Collectors.toList());
            this.displayItems = Arrays.asList(displayOutputs, (List)DISPLAY_TOOLS.get(), Arrays.asList(this.ingredient.func_193365_a()));
        }
        return this.displayItems;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return (ModifierEntry)RESULT.get();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends RecipeSerializer<OverslimeModifierRecipe> {
        public OverslimeModifierRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"restore_amount");
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        @Nullable
        public OverslimeModifierRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int restoreAmount = buffer.func_150792_a();
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        public void write(PacketBuffer buffer, OverslimeModifierRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(recipe.restoreAmount);
        }
    }
}

