/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierMatch;

public class ModifierRecipeLookup {
    public static final String DEFAULT_ERROR_KEY = Util.makeTranslationKey("recipe", "modifier.requirements_error");
    private static final Set<Item> MODIFIERS = new HashSet<Item>();
    private static final Map<Modifier, Pair<ModifierMatch, String>> REQUIREMENTS = new HashMap<Modifier, Pair<ModifierMatch, String>>();
    private static final Object2IntMap<Modifier> INCREMENTAL_PER_LEVEL = new Object2IntOpenHashMap();
    private static final Object2IntMap<Modifier> UPGRADE_SLOTS = new Object2IntOpenHashMap();
    private static final Object2IntMap<Modifier> ABILITY_SLOTS = new Object2IntOpenHashMap();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        MODIFIERS.clear();
        REQUIREMENTS.clear();
        INCREMENTAL_PER_LEVEL.clear();
        UPGRADE_SLOTS.clear();
        ABILITY_SLOTS.clear();
    });

    public static void addItem(Item item) {
        LISTENER.checkClear();
        MODIFIERS.add(item);
    }

    public static void addIngredient(Ingredient ingredient) {
        LISTENER.checkClear();
        for (ItemStack stack : ingredient.func_193365_a()) {
            MODIFIERS.add(stack.func_77973_b());
        }
    }

    public static void addIngredient(SizedIngredient ingredient) {
        LISTENER.checkClear();
        for (ItemStack stack : ingredient.getMatchingStacks()) {
            MODIFIERS.add(stack.func_77973_b());
        }
    }

    public static boolean isModifier(Item item) {
        return MODIFIERS.contains(item);
    }

    public static void addRequirement(Modifier modifier, ModifierMatch match, String error) {
        LISTENER.checkClear();
        if (match != ModifierMatch.ALWAYS && match.getMinLevel(modifier) == 0) {
            if (error.isEmpty()) {
                error = DEFAULT_ERROR_KEY;
            }
            REQUIREMENTS.put(modifier, (Pair<ModifierMatch, String>)Pair.of((Object)match, (Object)error));
        }
    }

    public static ValidatedResult checkRequirements(List<ModifierEntry> upgrades, List<ModifierEntry> modifiers) {
        for (ModifierEntry entry : upgrades) {
            Pair<ModifierMatch, String> pair = REQUIREMENTS.get(entry.getModifier());
            if (pair == null || ((ModifierMatch)pair.getFirst()).test(modifiers)) continue;
            return ValidatedResult.failure((String)pair.getSecond(), new Object[0]);
        }
        return ValidatedResult.PASS;
    }

    public static void setNeededPerLevel(Modifier modifier, int neededPerLevel) {
        if (INCREMENTAL_PER_LEVEL.containsKey((Object)modifier)) {
            int original = INCREMENTAL_PER_LEVEL.getInt((Object)modifier);
            if (original != neededPerLevel) {
                TConstruct.log.warn("Inconsistent amount needed per level for {}, originally {}, newest {}, keeping largest", (Object)modifier, (Object)original, (Object)neededPerLevel);
            }
            if (neededPerLevel > original) {
                INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
            }
        } else {
            INCREMENTAL_PER_LEVEL.put((Object)modifier, neededPerLevel);
        }
    }

    public static int getNeededPerLevel(Modifier modifier) {
        return INCREMENTAL_PER_LEVEL.getOrDefault((Object)modifier, 0);
    }

    public static int getUpgradeSlots(Modifier modifier) {
        return UPGRADE_SLOTS.getOrDefault((Object)modifier, -1);
    }

    public static int getAbilitySlots(Modifier modifier) {
        return ABILITY_SLOTS.getOrDefault((Object)modifier, -1);
    }

    public static void setUpgradeSlots(Modifier modifier, int slots) {
        if (!UPGRADE_SLOTS.containsKey((Object)modifier) || UPGRADE_SLOTS.getInt((Object)modifier) > slots) {
            UPGRADE_SLOTS.put((Object)modifier, slots);
        }
    }

    public static void setAbilitySlots(Modifier modifier, int slots) {
        if (!ABILITY_SLOTS.containsKey((Object)modifier) || ABILITY_SLOTS.getInt((Object)modifier) > slots) {
            ABILITY_SLOTS.put((Object)modifier, slots);
        }
    }
}

