/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<ModifierRecipeBuilder> {
    private final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();

    protected ModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static ModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new ModifierRecipeBuilder(modifier);
    }

    public static ModifierRecipeBuilder modifier(Modifier modifier) {
        return ModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public ModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public ModifierRecipeBuilder addInput(IItemProvider item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (IItemProvider[])new IItemProvider[]{item}));
    }

    public ModifierRecipeBuilder addInput(IItemProvider item) {
        return this.addInput(item, 1);
    }

    public ModifierRecipeBuilder addInput(ITag<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public ModifierRecipeBuilder addInput(ITag<Item> tag) {
        return this.addInput(tag, 1);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
    }

    private class FinishedRecipe
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super(ID, advancementID);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            JsonArray array = new JsonArray();
            for (SizedIngredient ingredient : ModifierRecipeBuilder.this.inputs) {
                array.add((JsonElement)ingredient.serialize());
            }
            json.add("inputs", (JsonElement)array);
            super.func_218610_a(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.modifierSerializer.get();
        }
    }
}

