/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierMatch;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public interface IDisplayModifierRecipe {
    public static final Function<Item, ItemStack> MAP_TOOL_FOR_RENDERING = item -> {
        if (item instanceof ToolCore) {
            return ((ToolCore)item).buildToolForRendering();
        }
        return new ItemStack((IItemProvider)item);
    };

    public List<List<ItemStack>> getDisplayItems();

    public ModifierEntry getDisplayResult();

    default public int getMaxLevel() {
        return 0;
    }

    default public int getUpgradeSlots() {
        return 0;
    }

    default public int getAbilitySlots() {
        return 0;
    }

    default public boolean hasRequirements() {
        return false;
    }

    default public String getRequirementsError() {
        return "";
    }

    default public boolean isIncremental() {
        return false;
    }

    public static Stream<Item> getAllModifiable() {
        return TinkerTags.Items.MODIFIABLE.func_230236_b_().stream();
    }

    public static ItemStack withModifiers(ItemStack stack, @Nullable ModifierMatch match, @Nullable ModifierEntry newModifier) {
        ModifierNBT.Builder builder = ModifierNBT.builder();
        if (match != null) {
            match.apply(builder);
        }
        if (newModifier != null) {
            builder.add(newModifier);
        }
        ItemStack output = stack.func_77946_l();
        output.func_196082_o().func_218657_a("tic_modifiers", (INBT)builder.build().serializeToNBT());
        return output;
    }
}

