/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierMatch;

public abstract class AbstractModifierRecipeBuilder<T extends AbstractModifierRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected static final Lazy<Ingredient> DEFAULT_TOOL = Lazy.of(() -> Ingredient.func_199805_a(TinkerTags.Items.MODIFIABLE));
    private final ModifierEntry result;
    private Ingredient tools = Ingredient.field_193370_a;
    private ModifierMatch requirements = ModifierMatch.ALWAYS;
    private String requirementsError = null;
    private int maxLevel = 0;
    private int upgradeSlots = 0;
    private int abilitySlots = 0;

    public T setTools(Ingredient tools) {
        this.tools = tools;
        return (T)((Object)this);
    }

    public T setTools(ITag<Item> tag) {
        return this.setTools(Ingredient.func_199805_a(tag));
    }

    public T setRequirements(ModifierMatch requirements) {
        this.requirements = requirements;
        return (T)((Object)this);
    }

    public T setRequirementsError(String requirementsError) {
        this.requirementsError = requirementsError;
        return (T)((Object)this);
    }

    public T setMaxLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level must be non-negative");
        }
        this.maxLevel = level;
        return (T)((Object)this);
    }

    public T setUpgradeSlots(int slots) {
        if (slots < 0) {
            throw new IllegalArgumentException("Slots must be positive");
        }
        if (this.abilitySlots != 0) {
            throw new IllegalStateException("Cannot set both upgrade and ability slots");
        }
        this.upgradeSlots = slots;
        return (T)((Object)this);
    }

    public T setAbilitySlots(int slots) {
        if (slots < 0) {
            throw new IllegalArgumentException("Slots must be positive");
        }
        if (this.upgradeSlots != 0) {
            throw new IllegalStateException("Cannot set both upgrade and ability slots");
        }
        this.abilitySlots = slots;
        return (T)((Object)this);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.getModifier().getId());
    }

    protected AbstractModifierRecipeBuilder(ModifierEntry result) {
        this.result = result;
    }

    protected abstract class ModifierFinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public ModifierFinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)AbstractModifierRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (AbstractModifierRecipeBuilder.this.tools == Ingredient.field_193370_a) {
                json.add("tools", ((Ingredient)DEFAULT_TOOL.get()).func_200304_c());
            } else {
                json.add("tools", AbstractModifierRecipeBuilder.this.tools.func_200304_c());
            }
            if (AbstractModifierRecipeBuilder.this.requirements != ModifierMatch.ALWAYS) {
                JsonObject reqJson = AbstractModifierRecipeBuilder.this.requirements.serialize();
                reqJson.addProperty("error", AbstractModifierRecipeBuilder.this.requirementsError);
                json.add("requirements", (JsonElement)reqJson);
            }
            json.add("result", (JsonElement)AbstractModifierRecipeBuilder.this.result.toJson());
            if (AbstractModifierRecipeBuilder.this.maxLevel != 0) {
                json.addProperty("max_level", (Number)AbstractModifierRecipeBuilder.this.maxLevel);
            }
            if (AbstractModifierRecipeBuilder.this.upgradeSlots != 0) {
                json.addProperty("upgrade_slots", (Number)AbstractModifierRecipeBuilder.this.upgradeSlots);
            }
            if (AbstractModifierRecipeBuilder.this.abilitySlots != 0) {
                json.addProperty("ability_slots", (Number)AbstractModifierRecipeBuilder.this.abilitySlots);
            }
        }
    }
}

