/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.modifier;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierMatch;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public abstract class AbstractModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    protected static final String KEY_MAX_LEVEL = Util.makeTranslationKey("recipe", "modifier.max_level");
    protected static final String KEY_NOT_ENOUGH_UPGRADES = Util.makeTranslationKey("recipe", "modifier.not_enough_upgrades");
    protected static final String KEY_NOT_ENOUGH_ABILITIES = Util.makeTranslationKey("recipe", "modifier.not_enough_abilities");
    protected static final ValidatedResult REQUIREMENTS_ERROR = ValidatedResult.failure(ModifierRecipeLookup.DEFAULT_ERROR_KEY, new Object[0]);
    private final ResourceLocation id;
    protected final Ingredient toolRequirement;
    protected final ModifierMatch requirements;
    protected final String requirementsError;
    protected final ModifierEntry result;
    private final int maxLevel;
    private final int upgradeSlots;
    private final int abilitySlots;
    private List<List<ItemStack>> displayItems = null;
    private ModifierEntry displayResult;

    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.requirements = requirements;
        this.requirementsError = requirementsError;
        this.result = result;
        this.maxLevel = maxLevel;
        this.upgradeSlots = upgradeSlots;
        this.abilitySlots = abilitySlots;
        ModifierRecipeLookup.addRequirement(result.getModifier(), requirements, requirementsError);
        if (abilitySlots > 0) {
            ModifierRecipeLookup.setAbilitySlots(result.getModifier(), abilitySlots / result.getLevel());
        } else {
            ModifierRecipeLookup.setUpgradeSlots(result.getModifier(), upgradeSlots / result.getLevel());
        }
    }

    @Override
    public abstract ValidatedResult getValidatedResult(ITinkerStationInventory var1);

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        if (this.displayResult == null) {
            int min = this.requirements.getMinLevel(this.result.getModifier());
            this.displayResult = min > 0 ? new ModifierEntry(this.result.getModifier(), this.result.getLevel() + min) : this.result;
        }
        return this.displayResult;
    }

    protected abstract void addIngredients(ImmutableList.Builder<List<ItemStack>> var1);

    @Override
    public List<List<ItemStack>> getDisplayItems() {
        if (this.displayItems == null) {
            List toolInputs = Arrays.stream(this.toolRequirement.func_193365_a()).map(stack -> {
                if (stack.func_77973_b() instanceof ToolCore) {
                    return ((ToolCore)stack.func_77973_b()).buildToolForRendering();
                }
                return stack;
            }).collect(Collectors.toList());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(toolInputs.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result)).collect(Collectors.toList()));
            builder.add(toolInputs.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, null)).collect(Collectors.toList()));
            this.addIngredients((ImmutableList.Builder<List<ItemStack>>)builder);
            this.displayItems = builder.build();
        }
        return this.displayItems;
    }

    @Override
    public boolean hasRequirements() {
        return this.requirements != ModifierMatch.ALWAYS;
    }

    @Override
    public String getRequirementsError() {
        if (this.requirementsError.isEmpty()) {
            return ModifierRecipeLookup.DEFAULT_ERROR_KEY;
        }
        return this.requirementsError;
    }

    protected ValidatedResult validatePrerequisites(ToolStack tool) {
        if (!this.requirements.test(tool.getModifierList())) {
            return this.requirementsError.isEmpty() ? REQUIREMENTS_ERROR : ValidatedResult.failure(this.requirementsError, new Object[0]);
        }
        if (this.maxLevel != 0 && tool.getUpgrades().getLevel(this.result.getModifier()) + this.result.getLevel() > this.maxLevel) {
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.maxLevel);
        }
        if (tool.getFreeUpgrades() < this.upgradeSlots) {
            return ValidatedResult.failure(KEY_NOT_ENOUGH_UPGRADES, this.upgradeSlots);
        }
        if (tool.getFreeAbilities() < this.abilitySlots) {
            return ValidatedResult.failure(KEY_NOT_ENOUGH_ABILITIES, this.abilitySlots);
        }
        return ValidatedResult.PASS;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getUpgradeSlots() {
        return this.upgradeSlots;
    }

    @Override
    public int getAbilitySlots() {
        return this.abilitySlots;
    }

    public static abstract class Serializer<T extends AbstractModifierRecipe>
    extends RecipeSerializer<T> {
        public abstract T read(ResourceLocation var1, JsonObject var2, Ingredient var3, ModifierMatch var4, String var5, ModifierEntry var6, int var7, int var8, int var9);

        public abstract T read(ResourceLocation var1, PacketBuffer var2, Ingredient var3, ModifierMatch var4, String var5, ModifierEntry var6, int var7, int var8, int var9);

        public final T read(ResourceLocation id, JsonObject json) {
            Ingredient toolRequirement = Ingredient.func_199802_a((JsonElement)json.get("tools"));
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = JSONUtils.func_152754_s((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = JSONUtils.func_151219_a((JsonObject)reqJson, (String)"error", (String)"");
            }
            ModifierEntry result = ModifierEntry.fromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)0);
            if (maxLevel < 0) {
                throw new JsonSyntaxException("max must be non-negative");
            }
            int upgradeSlots = JSONUtils.func_151208_a((JsonObject)json, (String)"upgrade_slots", (int)0);
            if (upgradeSlots < 0) {
                throw new JsonSyntaxException("upgrade_slots must be non-negative");
            }
            int abilitySlots = JSONUtils.func_151208_a((JsonObject)json, (String)"ability_slots", (int)0);
            if (abilitySlots < 0) {
                throw new JsonSyntaxException("ability_slots must be non-negative");
            }
            if (upgradeSlots > 0 && abilitySlots > 0) {
                throw new JsonSyntaxException("Cannot set both upgrade_slots and ability_slots");
            }
            return this.read(id, json, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        }

        public final T read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient toolRequirement = Ingredient.func_199566_b((PacketBuffer)buffer);
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.func_150789_c(Short.MAX_VALUE);
            ModifierEntry result = ModifierEntry.read(buffer);
            int maxLevel = buffer.func_150792_a();
            int upgradeSlots = buffer.func_150792_a();
            int abilitySlots = buffer.func_150792_a();
            return this.read(id, buffer, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((AbstractModifierRecipe)recipe).toolRequirement.func_199564_a(buffer);
            ((AbstractModifierRecipe)recipe).requirements.write(buffer);
            buffer.func_180714_a(((AbstractModifierRecipe)recipe).requirementsError);
            ((AbstractModifierRecipe)recipe).result.write(buffer);
            buffer.func_150787_b(((AbstractModifierRecipe)recipe).getMaxLevel());
            buffer.func_150787_b(((AbstractModifierRecipe)recipe).getUpgradeSlots());
            buffer.func_150787_b(((AbstractModifierRecipe)recipe).getAbilitySlots());
        }
    }
}

