/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.tables.TinkerTables;

public class ToolBuildingRecipe
implements ITinkerStationRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final ToolCore output;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.toolBuildingRecipeSerializer.get();
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World worldIn) {
        int i;
        if (!inv.getTinkerableStack().func_190926_b()) {
            return false;
        }
        List<IToolPart> parts = this.output.getToolDefinition().getRequiredComponents();
        for (i = 0; i < parts.size(); ++i) {
            if (parts.get(i).func_199767_j() == inv.getInput(i).func_77973_b()) continue;
            return false;
        }
        while (i < inv.getInputCount()) {
            if (!inv.getInput(i).func_190926_b()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(ITinkerStationInventory inv) {
        List<IMaterial> materials = IntStream.range(0, this.output.getToolDefinition().getRequiredComponents().size()).mapToObj(inv::getInput).map(IMaterialItem::getMaterialFromStack).collect(Collectors.toList());
        return ToolBuildHandler.buildItemFromMaterials(this.output, materials);
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.output);
    }

    public ToolBuildingRecipe(ResourceLocation id, String group, ToolCore output) {
        this.id = id;
        this.group = group;
        this.output = output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }
}

