/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;

public class PartRecipeSerializer
extends RecipeSerializer<PartRecipe> {
    public PartRecipe read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ResourceLocation pattern = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"pattern"));
        int cost = JSONUtils.func_151203_m((JsonObject)json, (String)"cost");
        JsonObject output = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        IMaterialItem item = (IMaterialItem)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)output, (String)"item"), (String)"result", IMaterialItem.class);
        int count = JSONUtils.func_151208_a((JsonObject)output, (String)"count", (int)1);
        return new PartRecipe(recipeId, group, pattern, cost, item, count);
    }

    @Nullable
    public PartRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            ResourceLocation pattern = new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE));
            int cost = buffer.readInt();
            IMaterialItem item = (IMaterialItem)RecipeHelper.readItem((PacketBuffer)buffer, IMaterialItem.class);
            byte count = buffer.readByte();
            return new PartRecipe(recipeId, group, pattern, cost, item, count);
        }
        catch (Exception e) {
            TConstruct.log.error("Error reading material recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, PartRecipe recipe) {
        try {
            buffer.func_180714_a(recipe.group);
            buffer.func_180714_a(recipe.pattern.toString());
            buffer.writeInt(recipe.cost);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.output);
            buffer.writeByte(recipe.outputCount);
        }
        catch (Exception e) {
            TConstruct.log.error("Error writing material recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

