/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderInventory;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipe
implements ICommonRecipe<IPartBuilderInventory> {
    protected final ResourceLocation id;
    protected final String group;
    protected final ResourceLocation pattern;
    protected final int cost;
    protected final IMaterialItem output;
    protected final int outputCount;

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.PART_BUILDER;
    }

    public ItemStack func_222128_h() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.partRecipeSerializer.get();
    }

    public boolean matchesPattern(IPartBuilderInventory inv) {
        return inv.getPatternStack().func_77973_b() == TinkerTables.pattern.get();
    }

    public boolean matches(IPartBuilderInventory inv, World world) {
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            IMaterial material = materialRecipe.getMaterial();
            return material.isCraftable() && this.output.canUseMaterial(material) && inv.getStack().func_190916_E() >= materialRecipe.getItemsUsed(this.cost);
        }
        return false;
    }

    public int getItemsUsed(IPartBuilderInventory inv) {
        return Optional.ofNullable(inv.getMaterial()).map(mat -> mat.getItemsUsed(this.cost)).orElse(1);
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.output);
    }

    public ItemStack getRecipeOutput(IMaterial material) {
        ItemStack stack = this.output.withMaterial(material);
        stack.func_190920_e(this.outputCount);
        return stack;
    }

    public ItemStack getCraftingResult(IPartBuilderInventory inv) {
        IMaterial material = IMaterial.UNKNOWN;
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            material = materialRecipe.getMaterial();
        }
        return this.getRecipeOutput(material);
    }

    public PartRecipe(ResourceLocation id, String group, ResourceLocation pattern, int cost, IMaterialItem output, int outputCount) {
        this.id = id;
        this.group = group;
        this.pattern = pattern;
        this.cost = cost;
        this.output = output;
        this.outputCount = outputCount;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ResourceLocation getPattern() {
        return this.pattern;
    }

    public int getCost() {
        return this.cost;
    }
}

