/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.mantle.recipe.inventory.IEmptyInventory;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class BeheadingRecipe
implements ICustomOutputRecipe<IEmptyInventory> {
    private final ResourceLocation id;
    private final EntityIngredient ingredient;
    private final ItemOutput output;
    private List<List<EntityType>> displayInputs;

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public ItemStack getOutput() {
        return this.output.get();
    }

    public ItemStack getOutput(Entity entity) {
        return this.getOutput().func_77946_l();
    }

    public Collection<EntityType<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public List<List<EntityType>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = ImmutableList.of((Object)ImmutableList.copyOf(this.getInputs()));
        }
        return this.displayInputs;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.beheadingSerializer.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.BEHEADING;
    }

    @Deprecated
    public boolean matches(IEmptyInventory inv, World worldIn) {
        return false;
    }

    public BeheadingRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput output) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends RecipeSerializer<BeheadingRecipe> {
        public BeheadingRecipe read(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            ItemOutput output = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            return new BeheadingRecipe(id, ingredient, output);
        }

        @Nullable
        public BeheadingRecipe read(ResourceLocation id, PacketBuffer buffer) {
            EntityIngredient ingredient = EntityIngredient.read((PacketBuffer)buffer);
            ItemOutput output = ItemOutput.read((PacketBuffer)buffer);
            return new BeheadingRecipe(id, ingredient, output);
        }

        public void write(PacketBuffer buffer, BeheadingRecipe recipe) {
            recipe.ingredient.write(buffer);
            recipe.output.write(buffer);
        }
    }
}

