/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipeBuilder
extends AbstractRecipeBuilder<MeltingRecipeBuilder> {
    private final Ingredient input;
    private final FluidStack output;
    private final int temperature;
    private final int time;
    private boolean isOre = false;
    private boolean isDamagable = false;

    public static MeltingRecipeBuilder melting(Ingredient input, FluidStack output, int temperature, int time) {
        if (temperature < 0) {
            throw new IllegalArgumentException("Invalid temperature " + temperature + ", must be greater than zero");
        }
        if (time <= 0) {
            throw new IllegalArgumentException("Invalid time " + time + ", must be greater than zero");
        }
        return new MeltingRecipeBuilder(input, output, temperature, time);
    }

    public static MeltingRecipeBuilder melting(Ingredient input, FluidStack output, float timeFactor) {
        int temperature = output.getFluid().getAttributes().getTemperature(output) - 300;
        return MeltingRecipeBuilder.melting(input, output, temperature, IMeltingRecipe.calcTime(temperature, timeFactor));
    }

    public static MeltingRecipeBuilder melting(Ingredient input, Fluid fluid, int amount, float timeFactor) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), timeFactor);
    }

    public static MeltingRecipeBuilder melting(Ingredient input, Fluid fluid, int amount) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), IMeltingRecipe.calcTimeFactor(amount));
    }

    public MeltingRecipeBuilder setOre() {
        this.isOre = true;
        return this;
    }

    public MeltingRecipeBuilder setDamagable() {
        this.isDamagable = true;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.output.getFluid().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.isOre && this.isDamagable) {
            throw new IllegalStateException("Builder cannot be both ore and damagable");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "melting");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private MeltingRecipeBuilder(Ingredient input, FluidStack output, int temperature, int time) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MeltingRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (!MeltingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MeltingRecipeBuilder.this.group);
            }
            json.add("ingredient", MeltingRecipeBuilder.this.input.func_200304_c());
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)MeltingRecipeBuilder.this.output));
            json.addProperty("temperature", (Number)MeltingRecipeBuilder.this.temperature);
            json.addProperty("time", (Number)MeltingRecipeBuilder.this.time);
        }

        public IRecipeSerializer<?> func_218609_c() {
            if (MeltingRecipeBuilder.this.isOre) {
                return (IRecipeSerializer)TinkerSmeltery.oreMeltingSerializer.get();
            }
            if (MeltingRecipeBuilder.this.isDamagable) {
                return (IRecipeSerializer)TinkerSmeltery.damagableMeltingSerializer.get();
            }
            return (IRecipeSerializer)TinkerSmeltery.meltingSerializer.get();
        }
    }
}

