/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipeBuilder
extends AbstractRecipeBuilder<MaterialMeltingRecipeBuilder> {
    private final IMaterialItem item;
    private final int cost;

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.item.func_199767_j().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "melting");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private MaterialMeltingRecipeBuilder(IMaterialItem item, int cost) {
        this.item = item;
        this.cost = cost;
    }

    public static MaterialMeltingRecipeBuilder melting(IMaterialItem item, int cost) {
        return new MaterialMeltingRecipeBuilder(item, cost);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialMeltingRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (!MaterialMeltingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MaterialMeltingRecipeBuilder.this.group);
            }
            json.addProperty("item", Objects.requireNonNull(MaterialMeltingRecipeBuilder.this.item.func_199767_j().getRegistryName()).toString());
            json.addProperty("item_cost", (Number)MaterialMeltingRecipeBuilder.this.cost);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerSmeltery.materialMeltingSerializer.get();
        }
    }
}

