/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipe
implements IMeltingRecipe,
IMultiRecipe<MeltingRecipe> {
    private final ResourceLocation id;
    private final String group;
    private final IMaterialItem item;
    private final int cost;
    private List<MeltingRecipe> multiRecipes;

    public boolean matches(IMeltingInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        return stack.func_77973_b() == this.item && this.item.getMaterial(stack).getFluid() != Fluids.field_204541_a;
    }

    @Override
    public FluidStack getOutput(IMeltingInventory inv) {
        IMaterial material = this.item.getMaterial(inv.getStack());
        return new FluidStack(material.getFluid(), material.getFluidPerUnit() * this.cost);
    }

    @Override
    public int getTemperature(IMeltingInventory inv) {
        return this.item.getMaterial(inv.getStack()).getTemperature();
    }

    private int getTime(IMaterial material) {
        return IMeltingRecipe.calcTimeForAmount(material.getTemperature(), material.getFluidPerUnit() * this.cost);
    }

    @Override
    public int getTime(IMeltingInventory inv) {
        return this.getTime(this.item.getMaterial(inv.getStack()));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.materialMeltingSerializer.get();
    }

    public List<MeltingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.getFluid() != Fluids.field_204541_a).map(mat -> {
                MaterialId matId = mat.getIdentifier();
                return new MeltingRecipe(new ResourceLocation(this.id.func_110624_b(), String.format("%s/%s/%s", this.id.func_110623_a(), matId.func_110624_b(), matId.func_110623_a())), this.group, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.item.withMaterial((IMaterial)mat)}), new FluidStack(mat.getFluid(), mat.getFluidPerUnit() * this.cost), mat.getTemperature(), this.getTime((IMaterial)mat));
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public MaterialMeltingRecipe(ResourceLocation id, String group, IMaterialItem item, int cost) {
        this.id = id;
        this.group = group;
        this.item = item;
        this.cost = cost;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public static class Serializer
    extends RecipeSerializer<MaterialMeltingRecipe> {
        public MaterialMeltingRecipe read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            IMaterialItem item = (IMaterialItem)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"item"), (String)"item", IMaterialItem.class);
            int cost = JSONUtils.func_151203_m((JsonObject)json, (String)"item_cost");
            return new MaterialMeltingRecipe(id, group, item, cost);
        }

        @Nullable
        public MaterialMeltingRecipe read(ResourceLocation id, PacketBuffer buffer) {
            try {
                String group = buffer.func_150789_c(Short.MAX_VALUE);
                IMaterialItem item = (IMaterialItem)RecipeHelper.readItem((PacketBuffer)buffer, IMaterialItem.class);
                int amount = buffer.func_150792_a();
                return new MaterialMeltingRecipe(id, group, item, amount);
            }
            catch (Exception e) {
                TConstruct.log.error("Error reading material melting recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public void write(PacketBuffer buffer, MaterialMeltingRecipe recipe) {
            try {
                buffer.func_180714_a(recipe.group);
                RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.item);
                buffer.func_150787_b(recipe.cost);
            }
            catch (Exception e) {
                TConstruct.log.error("Error reading material melting recipe from packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

