/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipeBuilder
extends AbstractRecipeBuilder<MaterialRecipeBuilder> {
    private final MaterialId material;
    private Ingredient ingredient = Ingredient.field_193370_a;
    private int value = 1;
    private int needed = 1;

    public MaterialRecipeBuilder setIngredient(Tag<Item> tag) {
        return this.setIngredient(Ingredient.func_199805_a(tag));
    }

    public MaterialRecipeBuilder setIngredient(IItemProvider item) {
        return this.setIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public MaterialRecipeBuilder setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, this.material);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.material == null) {
            throw new IllegalStateException("recipe " + id + " has no material associated with it");
        }
        if (this.ingredient == Ingredient.field_193370_a) {
            throw new IllegalStateException("recipe " + id + " must have ingredient set");
        }
        if (this.value <= 0) {
            throw new IllegalStateException("recipe " + id + " has no value associated with it");
        }
        if (this.needed <= 0) {
            throw new IllegalStateException("recipe " + id + " has no needed associated with it");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "materials");
        consumerIn.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private MaterialRecipeBuilder(MaterialId material) {
        this.material = material;
    }

    public static MaterialRecipeBuilder materialRecipe(MaterialId material) {
        return new MaterialRecipeBuilder(material);
    }

    public MaterialRecipeBuilder setValue(int value) {
        this.value = value;
        return this;
    }

    public MaterialRecipeBuilder setNeeded(int needed) {
        this.needed = needed;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (!MaterialRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MaterialRecipeBuilder.this.group);
            }
            json.add("ingredient", MaterialRecipeBuilder.this.ingredient.func_200304_c());
            json.addProperty("value", (Number)MaterialRecipeBuilder.this.value);
            json.addProperty("needed", (Number)MaterialRecipeBuilder.this.needed);
            json.addProperty("material", MaterialRecipeBuilder.this.material.toString());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerTables.materialRecipeSerializer.get();
        }
    }
}

