/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.inventory.ISingleItemInventory;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class MaterialRecipe
implements ICustomOutputRecipe<ISingleItemInventory> {
    public static final float INGOTS_PER_REPAIR = 3.0f;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final int value;
    protected final int needed;
    protected final MaterialId materialId;
    private final LazyValue<IMaterial> material;
    @Nullable
    private Float repairPerItem;

    public MaterialRecipe(ResourceLocation id, String group, Ingredient ingredient, int value, int needed, MaterialId materialId) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.value = value;
        this.needed = needed;
        this.materialId = materialId;
        this.material = new LazyValue(() -> MaterialRegistry.getMaterial(materialId));
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.MATERIAL;
    }

    public ItemStack func_222128_h() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.materialRecipeSerializer.get();
    }

    public boolean matches(ISingleItemInventory inv, World worldIn) {
        return this.ingredient.test(inv.getStack());
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient});
    }

    public IMaterial getMaterial() {
        return (IMaterial)this.material.func_179281_c();
    }

    public float getMaterialValue(ISingleItemInventory inv) {
        return (float)(inv.getStack().func_190916_E() * this.value) / (float)this.needed;
    }

    public int getItemsUsed(int itemCost) {
        int needed = itemCost * this.needed;
        int cost = needed / this.value;
        if (needed % this.value != 0) {
            ++cost;
        }
        return cost;
    }

    public int getRemainder(int itemCost) {
        return itemCost * this.needed % this.value;
    }

    public float getRepairPerItem() {
        if (this.repairPerItem == null) {
            this.repairPerItem = Float.valueOf((float)(this.getValue() * MaterialRecipe.getHeadDurability(this.materialId)) / 3.0f / (float)this.getNeeded());
        }
        return this.repairPerItem.floatValue();
    }

    public static int getHeadDurability(MaterialId materialId) {
        Optional<HeadMaterialStats> stats = MaterialRegistry.getInstance().getMaterialStats(materialId, HeadMaterialStats.ID);
        return stats.map(HeadMaterialStats::getDurability).orElse(0);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getValue() {
        return this.value;
    }

    public int getNeeded() {
        return this.needed;
    }
}

