/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.IFluidInventory;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;

public class MeltingFuel
implements ICustomOutputRecipe<IFluidInventory> {
    private final ResourceLocation id;
    private final String group;
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public MeltingFuel(ResourceLocation id, String group, FluidIngredient input, int duration, int temperature) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
        for (FluidStack fluid : input.getFluids()) {
            MeltingFuelLookup.addFuel(fluid.getFluid(), this);
        }
    }

    public boolean matches(IFluidInventory inv, World worldIn) {
        return this.matches(inv.getFluid());
    }

    public boolean matches(Fluid fluid) {
        return this.input.test(fluid);
    }

    public int getAmount(IFluidInventory inv) {
        return this.getAmount(inv.getFluid());
    }

    public int getAmount(Fluid fluid) {
        return this.input.getAmount(fluid);
    }

    public List<FluidStack> getInputs() {
        return this.input.getFluids();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.FUEL;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.fuelSerializer.get();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.TANK));
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends RecipeSerializer<MeltingFuel> {
        public MeltingFuel read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            FluidIngredient input = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
            int temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            return new MeltingFuel(id, group, input, duration, temperature);
        }

        public void write(PacketBuffer buffer, MeltingFuel recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.write(buffer);
            buffer.writeInt(recipe.duration);
            buffer.writeInt(recipe.temperature);
        }

        @Nullable
        public MeltingFuel read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            FluidIngredient input = FluidIngredient.read((PacketBuffer)buffer);
            int duration = buffer.readInt();
            int temperature = buffer.readInt();
            return new MeltingFuel(id, group, input, duration, temperature);
        }
    }
}

