/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.mantle.recipe.inventory.IEmptyInventory;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class EntityMeltingRecipe
implements ICustomOutputRecipe<IEmptyInventory> {
    private final ResourceLocation id;
    private final EntityIngredient ingredient;
    private final FluidStack output;
    private final int damage;
    private List<List<EntityType>> displayInputs;

    public boolean matches(EntityType<?> type) {
        return this.ingredient.test(type);
    }

    public FluidStack getOutput(LivingEntity entity) {
        return this.output.copy();
    }

    public List<List<EntityType>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = ImmutableList.of((Object)ImmutableList.copyOf(this.getInputs()));
        }
        return this.displayInputs;
    }

    public Collection<EntityType<?>> getInputs() {
        return this.ingredient.getTypes();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.entityMeltingSerializer.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.ENTITY_MELTING;
    }

    @Deprecated
    public boolean matches(IEmptyInventory inv, World worldIn) {
        return false;
    }

    public EntityMeltingRecipe(ResourceLocation id, EntityIngredient ingredient, FluidStack output, int damage) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getDamage() {
        return this.damage;
    }

    public static class Serializer
    extends RecipeSerializer<EntityMeltingRecipe> {
        public EntityMeltingRecipe read(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int damage = JSONUtils.func_151208_a((JsonObject)json, (String)"damage", (int)2);
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        @Nullable
        public EntityMeltingRecipe read(ResourceLocation id, PacketBuffer buffer) {
            EntityIngredient ingredient = EntityIngredient.read((PacketBuffer)buffer);
            FluidStack output = buffer.readFluidStack();
            int damage = buffer.func_150792_a();
            return new EntityMeltingRecipe(id, ingredient, output, damage);
        }

        public void write(PacketBuffer buffer, EntityMeltingRecipe recipe) {
            recipe.ingredient.write(buffer);
            buffer.writeFluidStack(recipe.output);
            buffer.func_150787_b(recipe.damage);
        }
    }
}

