/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;

public class MaterialItemCostLookup {
    private static final Object2IntMap<IMaterialItem> TABLE_LOOKUP = new Object2IntOpenHashMap(50);
    private static final Object2IntMap<IMaterialItem> BASIN_LOOKUP = new Object2IntOpenHashMap(50);
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        TABLE_LOOKUP.clear();
        BASIN_LOOKUP.clear();
    });

    public static void registerBasin(IMaterialItem item, int cost) {
        LISTENER.checkClear();
        BASIN_LOOKUP.put((Object)item, cost);
    }

    public static void registerTable(IMaterialItem item, int cost) {
        LISTENER.checkClear();
        TABLE_LOOKUP.put((Object)item, cost);
    }

    public static int getBasinCost(IMaterialItem item) {
        return BASIN_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static int getTableCost(IMaterialItem item) {
        return TABLE_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static Collection<Object2IntMap.Entry<IMaterialItem>> getAllBasinParts() {
        return BASIN_LOOKUP.object2IntEntrySet();
    }

    public static Collection<Object2IntMap.Entry<IMaterialItem>> getAllTableParts() {
        return TABLE_LOOKUP.object2IntEntrySet();
    }

    private MaterialItemCostLookup() {
    }
}

