/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialCastingRecipeBuilder
extends AbstractRecipeBuilder<MaterialCastingRecipeBuilder> {
    private final IMaterialItem result;
    private final MaterialCastingRecipe.Serializer<?> recipeSerializer;
    private Ingredient cast = Ingredient.field_193370_a;
    private int itemCost = 0;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static MaterialCastingRecipeBuilder basinRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (MaterialCastingRecipe.Serializer)TinkerSmeltery.basinMaterialSerializer.get());
    }

    public static MaterialCastingRecipeBuilder tableRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (MaterialCastingRecipe.Serializer)TinkerSmeltery.tableMaterialSerializer.get());
    }

    public MaterialCastingRecipeBuilder setCast(ITag<Item> tag, boolean consumed) {
        return this.setCast(Ingredient.func_199805_a(tag), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(IItemProvider item, boolean consumed) {
        return this.setCast(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(Ingredient cast, boolean consumed) {
        this.cast = cast;
        this.consumed = consumed;
        return this;
    }

    public MaterialCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.result.func_199767_j().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.itemCost <= 0) {
            throw new IllegalStateException("Material casting recipes require a positive amount of fluid");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private MaterialCastingRecipeBuilder(IMaterialItem result, MaterialCastingRecipe.Serializer<?> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static MaterialCastingRecipeBuilder castingRecipe(IMaterialItem result, MaterialCastingRecipe.Serializer<?> recipeSerializer) {
        return new MaterialCastingRecipeBuilder(result, recipeSerializer);
    }

    public MaterialCastingRecipeBuilder setItemCost(int itemCost) {
        this.itemCost = itemCost;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MaterialCastingRecipeBuilder.this, ID, advancementID);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return MaterialCastingRecipeBuilder.this.recipeSerializer;
        }

        public void func_218610_a(JsonObject json) {
            if (!MaterialCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MaterialCastingRecipeBuilder.this.group);
            }
            if (MaterialCastingRecipeBuilder.this.cast != Ingredient.field_193370_a) {
                json.add("cast", MaterialCastingRecipeBuilder.this.cast.func_200304_c());
                if (MaterialCastingRecipeBuilder.this.consumed) {
                    json.addProperty("cast_consumed", Boolean.valueOf(true));
                }
            }
            if (MaterialCastingRecipeBuilder.this.switchSlots) {
                json.addProperty("switch_slots", Boolean.valueOf(true));
            }
            json.addProperty("item_cost", (Number)MaterialCastingRecipeBuilder.this.itemCost);
            json.addProperty("result", Objects.requireNonNull(MaterialCastingRecipeBuilder.this.result.func_199767_j().getRegistryName()).toString());
        }
    }
}

