/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialItemCostLookup;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class MaterialCastingRecipe
extends AbstractCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    private final int itemCost;
    private final IMaterialItem result;
    private List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(IRecipeType<?> type, ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.itemCost = itemCost;
        this.result = result;
    }

    @Override
    public int getCoolingTime(ICastingInventory inv) {
        IMaterial material = MaterialRegistry.getMaterial(inv.getFluid());
        return ICastingRecipe.calcCoolingTime(material.getTemperature(), material.getFluidPerUnit() * this.itemCost);
    }

    public boolean matches(ICastingInventory inv, World worldIn) {
        return this.cast.test(inv.getStack()) && MaterialRegistry.getInstance().getMaterial(inv.getFluid()) != IMaterial.UNKNOWN;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.cast});
    }

    @Override
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.result);
    }

    @Override
    public int getFluidAmount(ICastingInventory inv) {
        return MaterialRegistry.getMaterial(inv.getFluid()).getFluidPerUnit() * this.itemCost;
    }

    public ItemStack getCraftingResult(ICastingInventory inv) {
        IMaterial material = MaterialRegistry.getInstance().getMaterial(inv.getFluid());
        return this.result.withMaterial(material);
    }

    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            IRecipeType<?> type = this.func_222127_g();
            List<ItemStack> castItems = Arrays.asList(this.cast.func_193365_a());
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.getFluid() != Fluids.field_204541_a).map(mat -> new DisplayCastingRecipe(type, castItems, Collections.singletonList(new FluidStack(mat.getFluid(), this.itemCost * mat.getFluidPerUnit())), this.result.withMaterial((IMaterial)mat), ICastingRecipe.calcCoolingTime(mat.getTemperature(), this.itemCost * mat.getFluidPerUnit()), this.consumed)).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends MaterialCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, JsonObject json) {
            int fluidAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"item_cost");
            IMaterialItem result = (IMaterialItem)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"result"), (String)"result", IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, fluidAmount, result, consumed, switchSlots);
        }

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, PacketBuffer buffer) {
            int fluidAmount = buffer.readInt();
            IMaterialItem result = (IMaterialItem)RecipeHelper.readItem((PacketBuffer)buffer, IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, fluidAmount, result, consumed, switchSlots);
        }

        @Override
        protected void writeExtra(PacketBuffer buffer, MaterialCastingRecipe recipe) {
            buffer.writeInt(recipe.itemCost);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.result);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends MaterialCastingRecipe> {
        public T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, int var4, IMaterialItem var5, boolean var6, boolean var7);
    }

    public static class Table
    extends MaterialCastingRecipe {
        public Table(ResourceLocation id, String group, Ingredient cast, int fluidAmount, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_TABLE, id, group, cast, fluidAmount, result, consumed, switchSlots);
            MaterialItemCostLookup.registerTable(result, fluidAmount);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableMaterialSerializer.get();
        }
    }

    public static class Basin
    extends MaterialCastingRecipe {
        public Basin(ResourceLocation id, String group, Ingredient cast, int fluidAmount, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_BASIN, id, group, cast, fluidAmount, result, consumed, switchSlots);
            MaterialItemCostLookup.registerBasin(result, fluidAmount);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinMaterialSerializer.get();
        }
    }
}

