/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class CompositeCastingRecipeBuilder
extends AbstractRecipeBuilder<CompositeCastingRecipeBuilder> {
    private final MaterialId input;
    private final MaterialId output;
    private final CompositeCastingRecipe.Serializer<?> recipeSerializer;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int temperature = -1;

    public static CompositeCastingRecipeBuilder basin(MaterialId input, MaterialId output) {
        return CompositeCastingRecipeBuilder.composite(input, output, (CompositeCastingRecipe.Serializer)TinkerSmeltery.basinCompositeSerializer.get());
    }

    public static CompositeCastingRecipeBuilder table(MaterialId input, MaterialId output) {
        return CompositeCastingRecipeBuilder.composite(input, output, (CompositeCastingRecipe.Serializer)TinkerSmeltery.tableCompositeSerializer.get());
    }

    public CompositeCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public CompositeCastingRecipeBuilder setFluid(ITag<Fluid> tagIn, int amount) {
        return this.setFluid(FluidIngredient.of(tagIn, (int)amount));
    }

    public CompositeCastingRecipeBuilder setFluid(FluidStack fluidStack) {
        if (this.temperature == -1) {
            this.temperature = fluidStack.getFluid().getAttributes().getTemperature(fluidStack) - 300;
        }
        return this.setFluid(FluidIngredient.of((FluidStack)fluidStack));
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Composite recipes require a fluid input");
        }
        if (this.temperature < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private CompositeCastingRecipeBuilder(MaterialId input, MaterialId output, CompositeCastingRecipe.Serializer<?> recipeSerializer) {
        this.input = input;
        this.output = output;
        this.recipeSerializer = recipeSerializer;
    }

    public static CompositeCastingRecipeBuilder composite(MaterialId input, MaterialId output, CompositeCastingRecipe.Serializer<?> recipeSerializer) {
        return new CompositeCastingRecipeBuilder(input, output, recipeSerializer);
    }

    public CompositeCastingRecipeBuilder setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)CompositeCastingRecipeBuilder.this, ID, advancementID);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return CompositeCastingRecipeBuilder.this.recipeSerializer;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("input", CompositeCastingRecipeBuilder.this.input.toString());
            json.add("fluid", CompositeCastingRecipeBuilder.this.fluid.serialize());
            json.addProperty("result", CompositeCastingRecipeBuilder.this.output.toString());
            json.addProperty("temperature", (Number)CompositeCastingRecipeBuilder.this.temperature);
        }
    }
}

