/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialItemCostLookup;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeSerializer;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class CompositeCastingRecipe
implements ICastingRecipe,
IMultiRecipe<IDisplayableCastingRecipe> {
    protected final IRecipeType<?> type;
    private final ResourceLocation id;
    protected final MaterialId inputId;
    protected final FluidIngredient fluid;
    protected final MaterialId outputId;
    protected final int coolingTemperature;
    private final Lazy<IMaterial> inputMaterial;
    private final Lazy<IMaterial> outputMaterial;
    private List<IDisplayableCastingRecipe> multiRecipes;

    protected CompositeCastingRecipe(IRecipeType<?> type, ResourceLocation id, MaterialId inputId, FluidIngredient fluid, MaterialId outputId, int coolingTemperature) {
        this.type = type;
        this.id = id;
        this.inputId = inputId;
        this.fluid = fluid;
        this.outputId = outputId;
        this.coolingTemperature = coolingTemperature;
        this.inputMaterial = Lazy.of(() -> MaterialRegistry.getMaterial(this.inputId));
        this.outputMaterial = Lazy.of(() -> MaterialRegistry.getMaterial(this.outputId));
    }

    protected abstract int getMaterialItemCost(IMaterialItem var1);

    public boolean matches(ICastingInventory inv, World worldIn) {
        if (!this.fluid.test(inv.getFluid())) {
            return false;
        }
        ItemStack stack = inv.getStack();
        Item item = stack.func_77973_b();
        if (item instanceof IMaterialItem) {
            IMaterialItem part = (IMaterialItem)item;
            return this.getMaterialItemCost(part) > 0 && this.inputId.equals((Object)part.getMaterial(stack).getIdentifier());
        }
        return false;
    }

    @Override
    public int getFluidAmount(ICastingInventory inv) {
        Item item = inv.getStack().func_77973_b();
        if (item instanceof IMaterialItem) {
            return this.fluid.getAmount(inv.getFluid()) * this.getMaterialItemCost((IMaterialItem)item);
        }
        return 0;
    }

    @Override
    public int getCoolingTime(ICastingInventory inv) {
        return ICastingRecipe.calcCoolingTime(this.coolingTemperature, this.getFluidAmount(inv));
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    public ItemStack getCraftingResult(ICastingInventory inv) {
        Item item = inv.getStack().func_77973_b();
        if (item instanceof IMaterialItem) {
            return ((IMaterialItem)item).withMaterial((IMaterial)this.outputMaterial.get());
        }
        return ItemStack.field_190927_a;
    }

    protected List<IDisplayableCastingRecipe> getRecipes(Collection<Object2IntMap.Entry<IMaterialItem>> parts) {
        if (this.multiRecipes == null) {
            List fluids = this.fluid.getFluids();
            this.multiRecipes = fluids.isEmpty() ? Collections.emptyList() : parts.stream().filter(entry -> entry.getIntValue() > 0).map(entry -> {
                IMaterialItem part = (IMaterialItem)entry.getKey();
                List<FluidStack> recipeFluids = fluids;
                int partCost = entry.getIntValue();
                if (partCost != 1) {
                    recipeFluids = recipeFluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * partCost)).collect(Collectors.toList());
                }
                return new DisplayCastingRecipe(this.func_222127_g(), Collections.singletonList(part.withMaterial((IMaterial)this.inputMaterial.get())), recipeFluids, part.withMaterial((IMaterial)this.outputMaterial.get()), ICastingRecipe.calcCoolingTime(this.coolingTemperature, ((FluidStack)recipeFluids.get(0)).getAmount()), true);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer<T extends CompositeCastingRecipe>
    extends RecipeSerializer<T> {
        private final IFactory<T> factory;

        public T read(ResourceLocation id, JsonObject json) {
            MaterialId input = MaterialRecipeSerializer.getMaterial(json, "input");
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            MaterialId output = MaterialRecipeSerializer.getMaterial(json, "result");
            int coolingTemperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            return this.factory.create(id, input, fluid, output, coolingTemperature);
        }

        public T read(ResourceLocation id, PacketBuffer buffer) {
            MaterialId input = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            FluidIngredient fluid = FluidIngredient.read((PacketBuffer)buffer);
            MaterialId output = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            int coolingTemperature = buffer.func_150792_a();
            return this.factory.create(id, input, fluid, output, coolingTemperature);
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((CompositeCastingRecipe)recipe).inputId.toString());
            ((CompositeCastingRecipe)recipe).fluid.write(buffer);
            buffer.func_180714_a(((CompositeCastingRecipe)recipe).outputId.toString());
            buffer.func_150787_b(((CompositeCastingRecipe)recipe).coolingTemperature);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends CompositeCastingRecipe> {
        public T create(ResourceLocation var1, MaterialId var2, FluidIngredient var3, MaterialId var4, int var5);
    }

    public static class Table
    extends CompositeCastingRecipe {
        public Table(ResourceLocation id, MaterialId inputId, FluidIngredient fluid, MaterialId outputId, int coolingTemperature) {
            super(RecipeTypes.CASTING_TABLE, id, inputId, fluid, outputId, coolingTemperature);
        }

        @Override
        protected int getMaterialItemCost(IMaterialItem item) {
            return MaterialItemCostLookup.getTableCost(item);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableCompositeSerializer.get();
        }

        public List<IDisplayableCastingRecipe> getRecipes() {
            return this.getRecipes(MaterialItemCostLookup.getAllTableParts());
        }
    }

    public static class Basin
    extends CompositeCastingRecipe {
        public Basin(ResourceLocation id, MaterialId inputId, FluidIngredient fluid, MaterialId outputId, int coolingTemperature) {
            super(RecipeTypes.CASTING_BASIN, id, inputId, fluid, outputId, coolingTemperature);
        }

        @Override
        protected int getMaterialItemCost(IMaterialItem item) {
            return MaterialItemCostLookup.getBasinCost(item);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinCompositeSerializer.get();
        }

        public List<IDisplayableCastingRecipe> getRecipes() {
            return this.getRecipes(MaterialItemCostLookup.getAllBasinParts());
        }
    }
}

