/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe;

public class ContainerFillingRecipeSerializer<T extends ContainerFillingRecipe>
extends RecipeSerializer<T> {
    private final IFactory<T> factory;

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        int fluidAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"fluid_amount");
        Item result = JSONUtils.func_188180_i((JsonObject)json, (String)"container");
        return this.factory.create(recipeId, group, fluidAmount, result);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            int fluidAmount = buffer.readInt();
            Item result = RecipeHelper.readItem((PacketBuffer)buffer);
            return this.factory.create(recipeId, group, fluidAmount, result);
        }
        catch (Exception e) {
            TConstruct.log.error("Error reading container filling recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            buffer.func_180714_a(((ContainerFillingRecipe)recipe).group);
            buffer.writeInt(((ContainerFillingRecipe)recipe).fluidAmount);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)((ContainerFillingRecipe)recipe).container);
        }
        catch (Exception e) {
            TConstruct.log.error("Error writing container filling recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public ContainerFillingRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public static interface IFactory<T extends ContainerFillingRecipe> {
        public T create(ResourceLocation var1, String var2, int var3, Item var4);
    }
}

