/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipeSerializer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ContainerFillingRecipeBuilder
extends AbstractRecipeBuilder<ContainerFillingRecipeBuilder> {
    private final ContainerFillingRecipeSerializer<?> recipeSerializer;
    private final int fluidAmount;
    private final Item result;

    private ContainerFillingRecipeBuilder(IItemProvider result, int fluidAmount, ContainerFillingRecipeSerializer<?> recipeSerializer) {
        this.result = result.func_199767_j();
        this.fluidAmount = fluidAmount;
        this.recipeSerializer = recipeSerializer;
    }

    public static ContainerFillingRecipeBuilder castingRecipe(IItemProvider result, int fluidAmount, ContainerFillingRecipeSerializer<?> recipeSerializer) {
        return new ContainerFillingRecipeBuilder(result, fluidAmount, recipeSerializer);
    }

    public static ContainerFillingRecipeBuilder basinRecipe(IItemProvider result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.basinFillingRecipeSerializer.get());
    }

    public static ContainerFillingRecipeBuilder tableRecipe(IItemProvider result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.tableFillingRecipeSerializer.get());
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.result.getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumerIn.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ContainerFillingRecipeBuilder.this, ID, advancementID);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ContainerFillingRecipeBuilder.this.recipeSerializer;
        }

        public void func_218610_a(JsonObject json) {
            if (!ContainerFillingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", ContainerFillingRecipeBuilder.this.group);
            }
            json.addProperty("fluid_amount", (Number)ContainerFillingRecipeBuilder.this.fluidAmount);
            json.addProperty("container", Objects.requireNonNull(ContainerFillingRecipeBuilder.this.result.func_199767_j().getRegistryName()).toString());
        }
    }
}

