/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.network;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class UpdateMaterialsPacket
implements IThreadsafePacket {
    private final Collection<IMaterial> materials;

    public UpdateMaterialsPacket(PacketBuffer buffer) {
        int materialCount = buffer.readInt();
        this.materials = new ArrayList<IMaterial>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.func_192575_l());
            int tier = buffer.func_150792_a();
            int sortOrder = buffer.func_150792_a();
            boolean craftable = buffer.readBoolean();
            Fluid fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
            if (fluid == null) {
                fluid = Fluids.field_204541_a;
            }
            int fluidPerUnit = buffer.func_150792_a();
            int color = buffer.readInt();
            int temperature = buffer.readInt();
            ImmutableList.Builder builder = ImmutableList.builder();
            int size = buffer.func_150792_a();
            for (int t = 0; t < size; ++t) {
                builder.add((Object)ModifierEntry.read(buffer));
            }
            this.materials.add(new Material(id, tier, sortOrder, fluid, fluidPerUnit, craftable, Color.func_240743_a_((int)color), temperature, (List<ModifierEntry>)builder.build()));
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.materials.size());
        this.materials.forEach(material -> {
            buffer.func_192572_a((ResourceLocation)material.getIdentifier());
            buffer.func_150787_b(material.getTier());
            buffer.func_150787_b(material.getSortOrder());
            buffer.writeBoolean(material.isCraftable());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (IForgeRegistryEntry)material.getFluid());
            buffer.func_150787_b(material.getFluidPerUnit());
            buffer.writeInt(material.getColor().field_240740_c_);
            buffer.writeInt(material.getTemperature());
            List<ModifierEntry> traits = material.getTraits();
            buffer.func_150787_b(traits.size());
            for (ModifierEntry entry : traits) {
                entry.write(buffer);
            }
        });
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialsFromServer(this);
    }

    public Collection<IMaterial> getMaterials() {
        return this.materials;
    }

    public UpdateMaterialsPacket(Collection<IMaterial> materials) {
        this.materials = materials;
    }
}

