/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolFluidCapability
implements IFluidHandlerItem {
    public static final ResourceLocation HAS_CAPABILITY = Util.getResource("has_fluid_capability");
    public static final ResourceLocation TOTAL_TANKS = Util.getResource("total_tanks");
    private final ItemStack container;
    private final ToolStack tool;

    public int getTanks() {
        return this.tool.getVolatileData().getInt(TOTAL_TANKS);
    }

    private <T> T runForTank(int tank, T defaultValue, ITankCallback<T> function) {
        for (ModifierEntry entry : this.tool.getModifierList()) {
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            int currentTanks = fluidModifier.getTanks(this.tool.getVolatileData());
            if (tank < currentTanks) {
                return function.run(fluidModifier, this.tool, entry.getLevel(), tank);
            }
            tank -= currentTanks;
        }
        return defaultValue;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.runForTank(tank, FluidStack.EMPTY, IFluidModifier::getFluidInTank);
    }

    public int getTankCapacity(int tank) {
        return this.runForTank(tank, 0, IFluidModifier::getTankCapacity);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.runForTank(tank, false, (module, tool, level, tank1) -> module.isFluidValid(tool, level, tank1, stack));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFilled = 0;
        for (ModifierEntry entry : this.tool.getModifierList()) {
            int filled;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (filled = fluidModifier.fill(this.tool, entry.getLevel(), resource, action)) <= 0) continue;
            if (filled >= resource.getAmount()) {
                return totalFilled + filled;
            }
            if (totalFilled == 0) {
                resource = resource.copy();
            }
            totalFilled += filled;
            resource.shrink(filled);
        }
        return totalFilled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        for (ModifierEntry entry : this.tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null || (drained = fluidModifier.drain((IModifierToolStack)this.tool, entry.getLevel(), resource, action)).isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                if (drained.getAmount() >= resource.getAmount()) {
                    return drained;
                }
                drainedSoFar = drained;
                resource = resource.copy();
            } else {
                drainedSoFar.grow(drained.getAmount());
            }
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        for (ModifierEntry entry : this.tool.getModifierList()) {
            FluidStack drained;
            IFluidModifier fluidModifier = entry.getModifier().getModule(IFluidModifier.class);
            if (fluidModifier == null) continue;
            if (toDrain.isEmpty()) {
                drained = fluidModifier.drain((IModifierToolStack)this.tool, entry.getLevel(), maxDrain, action);
                if (drained.isEmpty()) continue;
                if ((maxDrain -= drained.getAmount()) > 0) {
                    drainedSoFar = drained;
                    toDrain = new FluidStack(drained, maxDrain);
                    continue;
                }
                return drained;
            }
            drained = fluidModifier.drain((IModifierToolStack)this.tool, entry.getLevel(), toDrain, action);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }

    public static void addTanks(ModDataNBT volatileData, IFluidModifier modifier) {
        volatileData.putBoolean(HAS_CAPABILITY, true);
        volatileData.putInt(TOTAL_TANKS, modifier.getTanks(volatileData) + volatileData.getInt(TOTAL_TANKS));
    }

    public ToolFluidCapability(ItemStack container, ToolStack tool) {
        this.container = container;
        this.tool = tool;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    @FunctionalInterface
    private static interface ITankCallback<T> {
        public T run(IFluidModifier var1, IModifierToolStack var2, int var3, int var4);
    }

    public static interface IFluidModifier {
        default public int getTanks(IModDataReadOnly volatileData) {
            return 0;
        }

        default public FluidStack getFluidInTank(IModifierToolStack tool, int level, int tank) {
            return FluidStack.EMPTY;
        }

        default public int getTankCapacity(IModifierToolStack tool, int level, int tank) {
            return 0;
        }

        default public boolean isFluidValid(IModifierToolStack tool, int level, int tank, FluidStack fluid) {
            return true;
        }

        public int fill(IModifierToolStack var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IModifierToolStack var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IModifierToolStack var1, int var2, int var3, IFluidHandler.FluidAction var4);
    }
}

