/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.modifiers.Modifier;

public class ModifierEntry
implements Comparable<ModifierEntry> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Modifier modifier;
    private final int level;

    @Override
    public int compareTo(ModifierEntry other) {
        int priority2;
        Modifier mod1 = this.getModifier();
        Modifier mod2 = other.getModifier();
        int priority1 = mod1.getPriority();
        if (priority1 != (priority2 = mod2.getPriority())) {
            return Integer.compare(priority2, priority1);
        }
        return mod1.getId().func_110623_a().compareTo(mod2.getId().func_110623_a());
    }

    public static ModifierEntry fromJson(JsonObject json) {
        ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        if (!TinkerRegistries.EMPTY.equals((Object)name) && TinkerRegistries.MODIFIERS.containsKey(name)) {
            return new ModifierEntry((Modifier)TinkerRegistries.MODIFIERS.getValue(name), JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1));
        }
        throw new JsonSyntaxException("Unable to find modifier " + name);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.modifier.getId().toString());
        json.addProperty("level", (Number)this.level);
        return json;
    }

    public static ModifierEntry read(PacketBuffer buffer) {
        return new ModifierEntry((Modifier)buffer.readRegistryIdUnsafe(TinkerRegistries.MODIFIERS), buffer.func_150792_a());
    }

    public void write(PacketBuffer buffer) {
        buffer.writeRegistryIdUnsafe(TinkerRegistries.MODIFIERS, (IForgeRegistryEntry)this.modifier);
        buffer.func_150787_b(this.level);
    }

    public ModifierEntry(Modifier modifier, int level) {
        this.modifier = modifier;
        this.level = level;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return "ModifierEntry(modifier=" + this.getModifier() + ", level=" + this.getLevel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierEntry)) {
            return false;
        }
        ModifierEntry other = (ModifierEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Modifier this$modifier = this.getModifier();
        Modifier other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        return this.getLevel() == other.getLevel();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Modifier $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        result = result * 59 + this.getLevel();
        return result;
    }

    private static class Serializer
    implements JsonDeserializer<ModifierEntry>,
    JsonSerializer<ModifierEntry> {
        private Serializer() {
        }

        public ModifierEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ModifierEntry.fromJson(JSONUtils.func_151210_l((JsonElement)json, (String)"modifier"));
        }

        public JsonElement serialize(ModifierEntry entry, Type type, JsonSerializationContext context) {
            return entry.toJson();
        }
    }
}

