/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class Modifier
implements IForgeRegistryEntry<Modifier> {
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("tconstruct.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);
    protected static Random RANDOM = new Random();
    protected static final String KEY_LEVEL = "enchantment.level.";
    public static final int DEFAULT_PRIORITY = 100;
    private final int color;
    @Nullable
    private ModifierId registryName;
    @Nullable
    private String translationKey;
    @Nullable
    private ITextComponent displayName;
    @Nullable
    private List<ITextComponent> descriptionList;
    @Nullable
    private ITextComponent description;

    public int getPriority() {
        return 100;
    }

    public final Modifier setRegistryName(ResourceLocation name) {
        if (this.registryName != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + (Object)((Object)this.registryName));
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (!name.func_110624_b().equals(activeMod)) {
            LogManager.getLogger().info("Potentially Dangerous alternative prefix for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)name, (Object)activeMod);
        }
        this.registryName = new ModifierId(name);
        return this;
    }

    public ModifierId getId() {
        return Objects.requireNonNull(this.registryName, "Modifier has null registry name");
    }

    public Class<Modifier> getRegistryType() {
        return Modifier.class;
    }

    protected String makeTranslationKey() {
        return Util.func_200697_a((String)"modifier", (ResourceLocation)this.registryName);
    }

    public final String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.makeTranslationKey();
        }
        return this.translationKey;
    }

    protected ITextComponent makeDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    protected IFormattableTextComponent applyStyle(IFormattableTextComponent component) {
        return component.func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)this.color)));
    }

    public final ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)this.getColor())));
        }
        return this.displayName;
    }

    public ITextComponent getDisplayName(int level) {
        return this.applyStyle(new TranslationTextComponent(this.getTranslationKey()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(KEY_LEVEL + level)));
    }

    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        return this.getDisplayName(level);
    }

    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
    }

    public final List<ITextComponent> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(new TranslationTextComponent(this.getTranslationKey() + ".flavor").func_240699_a_(TextFormatting.ITALIC), new TranslationTextComponent(this.getTranslationKey() + ".description"));
        }
        return this.descriptionList;
    }

    public final ITextComponent getDescription() {
        if (this.description == null) {
            this.description = this.getDescriptionList().stream().reduce((c1, c2) -> new StringTextComponent("").func_230529_a_(c1).func_240702_b_("\n").func_230529_a_(c2)).orElse(StringTextComponent.field_240750_d_);
        }
        return this.description;
    }

    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
    }

    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
    }

    public void addAttributes(IModifierToolStack tool, int level, BiConsumer<Attribute, AttributeModifier> consumer) {
    }

    public ValidatedResult validate(IModifierToolStack tool, int level) {
        return ValidatedResult.PASS;
    }

    public int onDamageTool(IModifierToolStack toolStack, int level, int amount) {
        return amount;
    }

    public float getRepairFactor(IModifierToolStack toolStack, int level, float factor) {
        return factor;
    }

    public void onInventoryTick(IModifierToolStack tool, int level, World world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
    }

    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot;
    }

    public ActionResultType onBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResultType onEntityUse(IModifierToolStack tool, int level, PlayerEntity player, LivingEntity target, Hand hand) {
        return ActionResultType.PASS;
    }

    public ActionResultType onToolUse(IModifierToolStack tool, int level, World world, PlayerEntity player, Hand hand) {
        return ActionResultType.PASS;
    }

    public boolean onStoppedUsing(IModifierToolStack tool, int level, World world, LivingEntity entity, int timeLeft) {
        return false;
    }

    public boolean onFinishUsing(IModifierToolStack tool, int level, World world, LivingEntity entity) {
        return false;
    }

    public int getUseDuration(IModifierToolStack tool, int level) {
        return 0;
    }

    public UseAction getUseAction(IModifierToolStack tool, int level) {
        return UseAction.NONE;
    }

    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
    }

    public void applyEnchantments(IModifierToolStack tool, int level, BiConsumer<Enchantment, Integer> consumer) {
    }

    public void afterBlockBreak(IModifierToolStack tool, int level, World world, BlockState state, BlockPos pos, LivingEntity living, boolean wasEffective) {
    }

    public float applyLivingDamage(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, float baseDamage, float damage, boolean isCritical, boolean fullyCharged) {
        return damage;
    }

    public float beforeLivingHit(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, float damage, float baseKnockback, float knockback, boolean isCritical, boolean fullyCharged) {
        return knockback;
    }

    public int afterLivingHit(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, float damageDealt, boolean isCritical, boolean fullyCharged) {
        return 0;
    }

    public void failedLivingHit(IModifierToolStack tool, int level, LivingEntity attacker, LivingEntity target, boolean isCritical, boolean fullyCharged) {
    }

    public boolean shouldDisplay(boolean advanced) {
        return true;
    }

    public double getDamagePercentage(IModifierToolStack tool, int level) {
        return Double.NaN;
    }

    @Nullable
    public Boolean showDurabilityBar(IModifierToolStack tool, int level) {
        return null;
    }

    public int getDurabilityRGB(IModifierToolStack tool, int level) {
        return -1;
    }

    @Nullable
    public <T> T getModule(Class<T> type) {
        return null;
    }

    public static boolean attackEntitySecondary(DamageSource source, float damage, LivingEntity target, boolean noKnockback) {
        Optional<ModifiableAttributeInstance> knockbackResistance = Optional.ofNullable(target.func_110148_a(Attributes.field_233820_c_)).filter(attribute -> !attribute.func_180374_a(ANTI_KNOCKBACK_MODIFIER));
        float oldLastDamage = target.field_110153_bc;
        if (noKnockback) {
            knockbackResistance.ifPresent(attribute -> attribute.func_233767_b_(ANTI_KNOCKBACK_MODIFIER));
        }
        target.field_70172_ad = 0;
        boolean hit = target.func_70097_a(source, damage);
        target.field_110153_bc += oldLastDamage;
        if (noKnockback) {
            knockbackResistance.ifPresent(attribute -> attribute.func_111124_b(ANTI_KNOCKBACK_MODIFIER));
        }
        return hit;
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living) {
        if (living == null) {
            return null;
        }
        ItemStack stack = living.func_184614_ca();
        if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(TinkerTags.Items.MODIFIABLE)) {
            return null;
        }
        ToolStack tool = ToolStack.from(stack);
        return tool.isBroken() ? null : ToolStack.from(stack);
    }

    public static float getMiningModifier(LivingEntity entity) {
        EffectInstance miningFatigue;
        float modifier = 1.0f;
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            modifier *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.func_70660_b(Effects.field_76419_f)) != null) {
            switch (miningFatigue.func_76458_c()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)entity)) {
            modifier /= 5.0f;
        }
        if (!entity.func_233570_aj_()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    public Modifier(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public ModifierId getRegistryName() {
        return this.registryName;
    }
}

