/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.exception.TinkerAPIMaterialException;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJsonWrapper;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.network.UpdateMaterialStatsPacket;

public class MaterialStatsManager
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialStatsManager.class);
    public static final String FOLDER = "materials/stats";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<MaterialStatsId, Class<? extends IMaterialStats>> materialStatClasses = new HashMap<MaterialStatsId, Class<? extends IMaterialStats>>();
    private Map<MaterialId, Map<MaterialStatsId, IMaterialStats>> materialToStatsPerType = ImmutableMap.of();

    public MaterialStatsManager() {
        super(GSON, FOLDER);
    }

    public void registerMaterialStat(MaterialStatsId materialStatType, Class<? extends IMaterialStats> statsClass) {
        if (this.materialStatClasses.containsKey((Object)materialStatType)) {
            throw TinkerAPIMaterialException.materialStatsTypeRegisteredTwice(materialStatType);
        }
        this.materialStatClasses.put(materialStatType, statsClass);
    }

    public Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        return this.materialStatClasses.get((Object)id);
    }

    public <T extends IMaterialStats> Optional<T> getStats(MaterialId materialId, MaterialStatsId statId) {
        Map<MaterialStatsId, IMaterialStats> materialStats = this.materialToStatsPerType.getOrDefault((Object)materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of());
        IMaterialStats stats = materialStats.get((Object)statId);
        return Optional.ofNullable(stats);
    }

    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialToStatsPerType.getOrDefault((Object)materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of()).values();
    }

    public void updateMaterialStatsFromServer(Map<MaterialId, Collection<IMaterialStats>> materialStats) {
        this.materialToStatsPerType = materialStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, Function.identity()))));
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        Map<MaterialId, Map> statContentMappedByMaterial = splashList.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).map(entry -> this.loadFileContent((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).collect(Collectors.toMap(statsFileContent -> ((StatsFileContent)statsFileContent).materialId, statsFileContent -> this.transformAndCombineStatsForMaterial(((StatsFileContent)statsFileContent).stats, Collections.emptyList()), (map1, map2) -> this.transformAndCombineStatsForMaterial(map1.values(), map2.values())));
        this.materialToStatsPerType = statContentMappedByMaterial.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.deserializeMaterialStatsFromContent((Map)entry.getValue())));
        log.debug("Loaded stats for materials:{}", (Object)Util.toIndentedStringList(this.materialToStatsPerType.entrySet().stream().map(entry -> String.format("%s - %s", entry.getKey(), Arrays.toString(((Map)entry.getValue()).keySet().toArray()))).collect(Collectors.toList())));
        log.info("{} stats loaded for {} materials", (Object)this.materialToStatsPerType.values().stream().mapToInt(stats -> stats.keySet().size()).sum(), (Object)this.materialToStatsPerType.size());
    }

    public Object getUpdatePacket() {
        Map<MaterialId, Collection<IMaterialStats>> networkPayload = this.materialToStatsPerType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values()));
        return new UpdateMaterialStatsPacket(networkPayload);
    }

    private Map<MaterialStatsId, IMaterialStats> deserializeMaterialStatsFromContent(Map<MaterialStatsId, StatContent> contents) {
        Map<MaterialStatsId, Optional> loadedStats = contents.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.deserializeMaterialStat(((StatContent)entry.getValue()).statsId, ((StatContent)entry.getValue()).json)));
        return loadedStats.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (IMaterialStats)((Optional)entry.getValue()).get()));
    }

    private Map<MaterialStatsId, StatContent> transformAndCombineStatsForMaterial(Collection<StatContent> statsList1, Collection<StatContent> statsList2) {
        return Stream.concat(statsList1.stream(), statsList2.stream()).collect(Collectors.toMap(o -> ((StatContent)o).statsId, statContent -> statContent, (statContent, statContent2) -> {
            log.error("Duplicate stats {} for a material, ignoring additional definitions. Some mod is probably trying to add duplicate stats to another mods material.", (Object)((StatContent)statContent).statsId);
            return statContent;
        }));
    }

    @Nullable
    private StatsFileContent loadFileContent(ResourceLocation file, JsonObject jsonObject) {
        try {
            MaterialStatJsonWrapper materialStatJsonWrapper = (MaterialStatJsonWrapper)GSON.fromJson((JsonElement)jsonObject, MaterialStatJsonWrapper.class);
            MaterialId materialId = materialStatJsonWrapper.getMaterialId();
            if (materialId == null) {
                throw TinkerJSONException.materialStatsJsonWithoutMaterial();
            }
            JsonArray statsJsonArray = jsonObject.getAsJsonArray("stats");
            ArrayList<StatContent> stats = new ArrayList<StatContent>();
            if (statsJsonArray != null) {
                for (JsonElement statJson : statsJsonArray) {
                    try {
                        stats.add(this.loadStatContent(statJson));
                    }
                    catch (Exception e) {
                        log.error("Could not deserialize material stats from file {}. JSON: {}", (Object)file, (Object)statJson, (Object)e);
                    }
                }
            }
            return new StatsFileContent(new MaterialId(materialId), stats);
        }
        catch (Exception e) {
            log.error("Could not deserialize material stats file {}. JSON: {}", (Object)file, (Object)jsonObject, (Object)e);
            return null;
        }
    }

    private StatContent loadStatContent(JsonElement statsJson) {
        MaterialStatJsonWrapper.BaseMaterialStatsJson IMaterialStatsJson = (MaterialStatJsonWrapper.BaseMaterialStatsJson)GSON.fromJson(statsJson, MaterialStatJsonWrapper.BaseMaterialStatsJson.class);
        ResourceLocation statsId = IMaterialStatsJson.getId();
        if (statsId == null) {
            throw TinkerJSONException.materialStatsJsonWithoutId();
        }
        return new StatContent(new MaterialStatsId(statsId), statsJson);
    }

    private Optional<IMaterialStats> deserializeMaterialStat(MaterialStatsId statsId, JsonElement statsJson) {
        Class<? extends IMaterialStats> materialStatClass = this.materialStatClasses.get((Object)statsId);
        if (materialStatClass == null) {
            log.error("The material stat of type '" + (Object)((Object)statsId) + "' has not been registered");
            return Optional.empty();
        }
        return Optional.ofNullable(GSON.fromJson(statsJson, materialStatClass));
    }

    private static class StatsFileContent {
        private final MaterialId materialId;
        private final List<StatContent> stats;

        public StatsFileContent(MaterialId materialId, List<StatContent> stats) {
            this.materialId = materialId;
            this.stats = stats;
        }
    }

    private static class StatContent {
        private final MaterialStatsId statsId;
        private final JsonElement json;

        public StatContent(MaterialStatsId statsId, JsonElement json) {
            this.statsId = statsId;
            this.json = json;
        }
    }
}

