/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;

public abstract class BaseMaterialStats
implements IMaterialStats {
    @Override
    public IFormattableTextComponent getLocalizedName() {
        return new TranslationTextComponent(String.format("stat.tconstruct.%s", this.getIdentifier().func_110623_a()));
    }

    public static ITextComponent formatNumber(String loc, Color color, int number) {
        return BaseMaterialStats.formatNumber(loc, color, (float)number);
    }

    public static ITextComponent formatNumber(String loc, Color color, float number) {
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.df.format(number)).func_240700_a_(style -> style.func_240718_a_(color)));
    }

    public static ITextComponent formatNumberPercent(String loc, Color color, float number) {
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.dfPercent.format(number)).func_240700_a_(style -> style.func_240718_a_(color)));
    }

    public static ITextComponent formatColoredMultiplier(String loc, float number) {
        float hue = MathHelper.func_188207_b((float)(number - 0.5f), (float)2.0f);
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.dfMultiplier.format(number)).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)MathHelper.func_181758_c((float)(hue / 1.5f), (float)1.0f, (float)1.0f)))));
    }

    protected static String makeTooltipKey(String name) {
        return Util.makeTranslationKey("stat", name);
    }

    protected static ITextComponent makeTooltip(String name) {
        return new TranslationTextComponent(BaseMaterialStats.makeTooltipKey(name));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMaterialStats)) {
            return false;
        }
        BaseMaterialStats other = (BaseMaterialStats)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMaterialStats;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

