/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialJson;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.network.UpdateMaterialsPacket;

public class MaterialManager
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialManager.class);
    public static final String FOLDER = "materials/definition";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.SERIALIZER).registerTypeAdapter(ICondition.class, (Object)new ConditionSerializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<MaterialId, IMaterial> materials = Collections.emptyMap();
    private Map<Fluid, IMaterial> fluidLookup = Collections.emptyMap();
    private List<IMaterial> sortedMaterials = Collections.emptyList();

    public MaterialManager() {
        super(GSON, FOLDER);
    }

    public Collection<IMaterial> getAllMaterials() {
        return this.sortedMaterials;
    }

    public Optional<IMaterial> getMaterial(MaterialId materialId) {
        return Optional.ofNullable(this.materials.get((Object)materialId));
    }

    public Optional<IMaterial> getMaterial(Fluid fluid) {
        return Optional.ofNullable(this.fluidLookup.get(fluid));
    }

    private void onMaterialUpdate() {
        this.fluidLookup = this.materials.values().stream().filter(mat -> mat.getFluid() != Fluids.field_204541_a).collect(Collectors.toMap(IMaterial::getFluid, Function.identity()));
        this.sortedMaterials = this.materials.values().stream().sorted().collect(Collectors.toList());
    }

    public void updateMaterialsFromServer(Collection<IMaterial> materialList) {
        this.materials = materialList.stream().filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, Function.identity()));
        this.onMaterialUpdate();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.materials = splashList.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).map(entry -> this.loadMaterial((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, material -> material));
        this.onMaterialUpdate();
        log.debug("Loaded materials: {}", (Object)Util.toIndentedStringList(this.materials.keySet()));
        log.info("{} materials loaded", (Object)this.materials.size());
    }

    public Object getUpdatePacket() {
        return new UpdateMaterialsPacket(this.materials.values());
    }

    private static int orDefault(@Nullable Integer integer, int def) {
        return integer == null ? def : integer;
    }

    @Nullable
    private IMaterial loadMaterial(ResourceLocation materialId, JsonObject jsonObject) {
        try {
            MaterialJson materialJson = (MaterialJson)GSON.fromJson((JsonElement)jsonObject, MaterialJson.class);
            ICondition condition = materialJson.getCondition();
            if (condition != null && !condition.test()) {
                log.debug("Skipped loading material {} as it did not match the condition", (Object)materialId);
                return null;
            }
            if (materialJson.getCraftable() == null) {
                throw TinkerJSONException.materialJsonWithoutCraftingInformation(materialId);
            }
            boolean isCraftable = Boolean.TRUE.equals(materialJson.getCraftable());
            int temperature = 0;
            int fluidPerUnit = 0;
            Fluid fluid = this.loadFluid(materialId, materialJson);
            if (fluid != Fluids.field_204541_a) {
                fluidPerUnit = Optional.ofNullable(materialJson.getFluidPerUnit()).orElse(0);
                temperature = Optional.ofNullable(materialJson.getTemperature()).filter(n -> n >= 0).orElse(0);
            }
            Color color = Optional.ofNullable(materialJson.getTextColor()).filter(str -> !str.isEmpty()).map(Color::func_240745_a_).orElse(Material.WHITE);
            Object[] traits = materialJson.getTraits();
            return new Material(materialId, MaterialManager.orDefault(materialJson.getTier(), 0), MaterialManager.orDefault(materialJson.getSortOrder(), 100), fluid, fluidPerUnit, isCraftable, color, temperature, (List<ModifierEntry>)(traits == null ? Collections.emptyList() : ImmutableList.copyOf((Object[])traits)));
        }
        catch (Exception e) {
            log.error("Could not deserialize material {}. JSON: {}", (Object)materialId, (Object)jsonObject, (Object)e);
            return null;
        }
    }

    private Fluid loadFluid(ResourceLocation materialId, MaterialJson materialJson) {
        ResourceLocation fluidId = materialJson.getFluid();
        Fluid fluid = Fluids.field_204541_a;
        if (fluidId != null && ((fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId)) == null || fluid.func_207188_f().func_206888_e())) {
            log.warn("Could not find fluid {} for material {}", (Object)fluidId, (Object)materialId);
            fluid = Fluids.field_204541_a;
        }
        return fluid;
    }

    private static class ConditionSerializer
    implements JsonDeserializer<ICondition>,
    JsonSerializer<ICondition> {
        private ConditionSerializer() {
        }

        public ICondition deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return CraftingHelper.getCondition((JsonObject)JSONUtils.func_151210_l((JsonElement)json, (String)"condition"));
        }

        public JsonElement serialize(ICondition condition, Type type, JsonSerializationContext context) {
            return CraftingHelper.serialize((ICondition)condition);
        }
    }
}

