/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class Material
implements IMaterial {
    protected static final Color WHITE = Color.func_240743_a_((int)0xFFFFFF);
    private final MaterialId identifier;
    private final int tier;
    private final int sortOrder;
    protected final Fluid fluid;
    private final int fluidPerUnit;
    private final boolean craftable;
    private final String translationKey;
    private final Color color;
    private final int temperature;
    private final List<ModifierEntry> traits;

    public Material(ResourceLocation identifier, int tier, int order, Fluid fluid, int fluidPerUnit, boolean craftable, Color color, int temperature, List<ModifierEntry> traits) {
        this.identifier = new MaterialId(identifier);
        this.tier = tier;
        this.sortOrder = order;
        this.fluid = fluid;
        this.fluidPerUnit = fluidPerUnit;
        this.craftable = craftable;
        this.translationKey = Util.func_200697_a((String)"material", (ResourceLocation)identifier);
        this.color = color;
        this.temperature = temperature;
        this.traits = traits;
    }

    protected Material(ResourceLocation identifier, Fluid fluid, boolean craftable) {
        this(identifier, 0, -1, fluid, 0, craftable, WHITE, 0, Collections.emptyList());
    }

    @Override
    public MaterialId getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public int getFluidPerUnit() {
        return this.fluidPerUnit;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public List<ModifierEntry> getTraits() {
        return this.traits;
    }
}

