/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public interface IMaterial
extends Comparable<IMaterial> {
    public static final MaterialId UNKNOWN_ID = new MaterialId("tconstruct", "unknown");
    public static final IMaterial UNKNOWN = new Material(UNKNOWN_ID, Fluids.field_204541_a, false);

    public MaterialId getIdentifier();

    public boolean isCraftable();

    public Fluid getFluid();

    public int getFluidPerUnit();

    default public String getTranslationKey() {
        return Util.func_200697_a((String)"material", (ResourceLocation)this.getIdentifier());
    }

    public Color getColor();

    public int getTemperature();

    public List<ModifierEntry> getTraits();

    public int getTier();

    public int getSortOrder();

    @Override
    default public int compareTo(IMaterial other) {
        if (this.getTier() != other.getTier()) {
            return Integer.compare(this.getTier(), other.getTier());
        }
        if (this.getSortOrder() != other.getSortOrder()) {
            return Integer.compare(this.getSortOrder(), other.getSortOrder());
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }
}

