/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericDataProvider
implements IDataProvider {
    private static final Logger log = LogManager.getLogger(GenericDataProvider.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator generator;
    private final String folder;
    private final Gson gson;

    public GenericDataProvider(DataGenerator generator, String folder) {
        this(generator, folder, GSON);
    }

    protected void saveThing(DirectoryCache cache, ResourceLocation location, Object materialJson) {
        try {
            String json = this.gson.toJson(materialJson);
            Path path = this.generator.func_200391_b().resolve(Paths.get("data", location.func_110624_b(), this.folder, location.func_110623_a() + ".json"));
            String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException e) {
            log.error("Couldn't create data for {}", (Object)location, (Object)e);
        }
    }

    public GenericDataProvider(DataGenerator generator, String folder, Gson gson) {
        this.generator = generator;
        this.folder = folder;
        this.gson = gson;
    }
}

