/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FluidTooltipHandler {
    private static final Map<Fluid, List<FluidGuiEntry>> CACHE = new HashMap<Fluid, List<FluidGuiEntry>>();
    public static final ITextComponent HOLD_SHIFT = new TranslationTextComponent(Util.makeTranslationKey("gui", "fluid.hold_shift")).func_240699_a_(TextFormatting.GRAY);
    private static final FluidGuiEntry KILOBUCKET = new FluidGuiEntry("kilobucket", 1000000);
    private static final FluidGuiEntry BUCKET = new FluidGuiEntry("bucket", 1000);
    private static final FluidGuiEntry MILLIBUCKET = new FluidGuiEntry("millibucket", 1);
    private static final FluidGuiEntry INGOT = new FluidGuiEntry("ingot", 144);
    private static final FluidGuiEntry BLOCK = new FluidGuiEntry("block", 1296);
    private static final FluidGuiEntry PANE = new FluidGuiEntry("pane", 250);
    private static final FluidGuiEntry SLIMEBALL = new FluidGuiEntry("slimeball", 250);
    private static final Map<Item, FluidGuiEntry> TOOLTIP_OPTIONS = new IdentityHashMap<Item, FluidGuiEntry>();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(FluidTooltipHandler::onRecipesUpdated);
        TOOLTIP_OPTIONS.put((Item)TinkerSmeltery.ingotCast.get(), INGOT);
        TOOLTIP_OPTIONS.put((Item)TinkerSmeltery.nuggetCast.get(), new FluidGuiEntry("nugget", 16));
        TOOLTIP_OPTIONS.put((Item)TinkerSmeltery.gemCast.get(), new FluidGuiEntry("gem", 250));
    }

    private static void onRecipesUpdated(RecipesUpdatedEvent event) {
        CACHE.clear();
    }

    public static List<ITextComponent> getFluidTooltip(FluidStack fluid) {
        return FluidTooltipHandler.getFluidTooltip(fluid, fluid.getAmount());
    }

    public static List<ITextComponent> getFluidTooltip(FluidStack fluid, int amount) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add((ITextComponent)fluid.getDisplayName().func_230531_f_().func_240699_a_(TextFormatting.WHITE));
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), amount, tooltip);
        ModList.get().getModContainerById(Objects.requireNonNull(fluid.getFluid().getRegistryName()).func_110624_b()).map(container -> container.getModInfo().getDisplayName()).ifPresent(name -> tooltip.add((ITextComponent)new StringTextComponent(name).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC})));
        return tooltip;
    }

    public static void appendMaterial(FluidStack fluid, List<ITextComponent> tooltip) {
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), fluid.getAmount(), tooltip);
    }

    public static void appendMaterial(Fluid fluid, int original, List<ITextComponent> tooltip) {
        if (FluidTooltipHandler.appendMaterialNoShift(fluid, original, tooltip)) {
            FluidTooltipHandler.appendShift(tooltip);
        }
    }

    public static boolean appendMaterialNoShift(Fluid fluid, int original, List<ITextComponent> tooltip) {
        int amount = original;
        if (!Screen.func_231173_s_()) {
            List entries = CACHE.computeIfAbsent(fluid, FluidTooltipHandler::calcFluidEntries);
            for (FluidGuiEntry entry : entries) {
                amount = entry.getText(tooltip, amount);
            }
        }
        FluidTooltipHandler.appendBuckets(amount, tooltip);
        return amount != original;
    }

    public static void appendShift(List<ITextComponent> tooltip) {
        if (!Screen.func_231173_s_()) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add(HOLD_SHIFT);
        }
    }

    public static void appendIngots(int amount, List<ITextComponent> tooltip) {
        amount = FluidTooltipHandler.INGOT.getText(tooltip, amount);
        FluidTooltipHandler.appendBuckets(amount, tooltip);
    }

    public static void appendBuckets(int amount, List<ITextComponent> tooltip) {
        amount = FluidTooltipHandler.KILOBUCKET.getText(tooltip, amount);
        amount = FluidTooltipHandler.BUCKET.getText(tooltip, amount);
        FluidTooltipHandler.MILLIBUCKET.getText(tooltip, amount);
    }

    private static List<FluidGuiEntry> calcFluidEntries(Fluid fluid) {
        FluidIngredient ingredient;
        assert (Minecraft.func_71410_x().field_71441_e != null);
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        ArrayList<FluidGuiEntry> list = new ArrayList<FluidGuiEntry>();
        for (ItemCastingRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.CASTING_TABLE, ItemCastingRecipe.class)) {
            ingredient = recipe.getFluid();
            if (!ingredient.test(fluid)) continue;
            Ingredient cast = recipe.getCast();
            if (cast == Ingredient.field_193370_a) {
                FluidGuiEntry entry2 = fluid.func_207185_a(TinkerTags.Fluids.SLIMELIKE) ? SLIMEBALL : PANE;
                list.add(entry2.withAmount(ingredient.getAmount(fluid)));
                continue;
            }
            Arrays.stream(recipe.getCast().func_193365_a()).map(stack -> TOOLTIP_OPTIONS.get(stack.func_77973_b())).filter(Objects::nonNull).findFirst().ifPresent(entry -> list.add(((FluidGuiEntry)entry).withAmount(ingredient.getAmount(fluid))));
        }
        for (ItemCastingRecipe recipe : RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.CASTING_BASIN, ItemCastingRecipe.class)) {
            ingredient = recipe.getFluid();
            if (recipe.getCast() != Ingredient.field_193370_a || !ingredient.test(fluid)) continue;
            list.add(FluidTooltipHandler.BLOCK.withAmount(ingredient.getAmount(fluid)));
        }
        list.sort(null);
        return list;
    }

    private FluidTooltipHandler() {
    }

    private static class FluidGuiEntry
    implements Comparable<FluidGuiEntry> {
        private final String translationKey;
        private final int needed;

        private FluidGuiEntry(String name, int needed) {
            this.translationKey = Util.makeTranslationKey("gui", "fluid." + name);
            this.needed = needed;
        }

        private FluidGuiEntry(FluidGuiEntry parent, int needed) {
            this.translationKey = parent.translationKey;
            this.needed = needed;
        }

        private FluidGuiEntry withAmount(int amount) {
            if (amount == this.needed) {
                return this;
            }
            return new FluidGuiEntry(this, amount);
        }

        private int getText(List<ITextComponent> tooltip, int amount) {
            int full = amount / this.needed;
            if (full > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent(this.translationKey, new Object[]{full}).func_240699_a_(TextFormatting.GRAY));
            }
            return amount % this.needed;
        }

        @Override
        public int compareTo(FluidGuiEntry other) {
            if (this.needed != other.needed) {
                return Integer.compare(other.needed, this.needed);
            }
            return this.translationKey.compareTo(other.translationKey);
        }

        public int getNeeded() {
            return this.needed;
        }
    }
}

