/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;

public class ToolModel
implements IModelGeometry<ToolModel> {
    public static final Loader LOADER = new Loader();
    private final List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vector2f offset;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        for (ToolPart part : this.toolParts) {
            MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, false), null);
            if (part.hasBroken()) {
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, false), null);
            }
            if (!this.isLarge) continue;
            MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, true), null);
            if (!part.hasBroken()) continue;
            MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, true), null);
        }
        return allTextures;
    }

    private static IBakedModel bakeInternal(IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, @Nullable TransformationMatrix largeTransforms, List<ToolPart> parts, List<MaterialId> materials, boolean isBroken, ItemOverrideList overrides) {
        TextureAtlasSprite particle = null;
        ImmutableList.Builder smallBuilder = ImmutableList.builder();
        ImmutableList.Builder largeBuilder = ImmutableList.builder();
        Consumer<ImmutableList<BakedQuad>> largeConsumer = arg_0 -> ((ImmutableList.Builder)largeBuilder).addAll(arg_0);
        Consumer<Object> smallConsumer = largeTransforms != null ? quads -> {
            for (BakedQuad quad : quads) {
                if (quad.func_178210_d() != Direction.SOUTH) continue;
                smallBuilder.add((Object)quad);
            }
        } : arg_0 -> ((ImmutableList.Builder)smallBuilder).addAll(arg_0);
        for (ToolPart part : parts) {
            int index = part.getIndex();
            MaterialId material = null;
            if (index < materials.size()) {
                material = materials.get(index);
            }
            particle = MaterialModel.getPartQuads(smallConsumer, owner, spriteGetter, TransformationMatrix.func_227983_a_(), part.getName(isBroken, false), index, material);
            if (largeTransforms == null) continue;
            MaterialModel.getPartQuads(largeConsumer, owner, spriteGetter, largeTransforms, part.getName(isBroken, true), index, material);
        }
        assert (particle != null);
        ImmutableMap transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((IModelTransform)owner.getCombinedTransform()));
        if (largeTransforms != null) {
            return new BakedLargeToolModel(largeBuilder.build(), smallBuilder.build(), particle, transformMap, overrides, owner.isSideLit());
        }
        return new BakedItemModel(smallBuilder.build(), particle, transformMap, overrides, true, owner.isSideLit());
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TransformationMatrix largeTransforms = this.isLarge ? new TransformationMatrix(new Vector3f((this.offset.field_189982_i - 8.0f) / 32.0f, (-this.offset.field_189983_j - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, largeTransforms);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, Collections.emptyList(), false, overrides);
    }

    public ToolModel(List<ToolPart> toolParts, boolean isLarge, Vector2f offset) {
        this.toolParts = toolParts;
        this.isLarge = isLarge;
        this.offset = offset;
    }

    private static class Loader
    implements IModelLoader<ToolModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ToolModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            List parts = JsonHelper.parseList((JsonObject)modelContents, (String)"parts", ToolPart::read);
            boolean isLarge = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"large", (boolean)false);
            Vector2f offset = Vector2f.field_189974_a;
            if (modelContents.has("large_offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "large_offset");
            }
            return new ToolModel(parts, isLarge, offset);
        }
    }

    private static class BakedLargeToolGui
    extends BakedModelWrapper<BakedLargeToolModel> {
        private final List<BakedQuad> guiQuads;

        public BakedLargeToolGui(BakedLargeToolModel model, List<BakedQuad> guiQuads) {
            super((IBakedModel)model);
            this.guiQuads = guiQuads;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.guiQuads;
            }
            return ImmutableList.of();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transform, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)((BakedLargeToolModel)this.originalModel).transforms, (ItemCameraTransforms.TransformType)transform, (MatrixStack)mat);
        }
    }

    private static class BakedLargeToolModel
    implements IBakedModel {
        private final ImmutableList<BakedQuad> largeQuads;
        private final TextureAtlasSprite particleTexture;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;
        private final ItemOverrideList overrides;
        private final boolean isSideLit;
        private final IBakedModel guiModel;

        private BakedLargeToolModel(ImmutableList<BakedQuad> largeQuads, ImmutableList<BakedQuad> smallQuads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, ItemOverrideList overrides, boolean isSideLit) {
            this.largeQuads = largeQuads;
            this.particleTexture = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            this.isSideLit = isSideLit;
            this.guiModel = new BakedLargeToolGui(this, (List<BakedQuad>)smallQuads);
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.largeQuads;
            }
            return ImmutableList.of();
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack mat) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                return this.guiModel.handlePerspective(type, mat);
            }
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type, (MatrixStack)mat);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }
    }

    private static final class MaterialOverrideHandler
    extends ItemOverrideList {
        private final Map<List<MaterialId>, IBakedModel> cleanCache = new HashMap<List<MaterialId>, IBakedModel>();
        private final Map<List<MaterialId>, IBakedModel> brokenCache = new HashMap<List<MaterialId>, IBakedModel>();
        private final IModelConfiguration owner;
        private final List<ToolPart> toolParts;
        @Nullable
        private final TransformationMatrix largeTransforms;

        private MaterialOverrideHandler(IModelConfiguration owner, List<ToolPart> toolParts, @Nullable TransformationMatrix largeTransforms) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.largeTransforms = largeTransforms;
        }

        private IBakedModel bakeDynamic(List<MaterialId> materials, boolean isBroken) {
            return ToolModel.bakeInternal(this.owner, ModelLoader.defaultTextureGetter(), this.largeTransforms, this.toolParts, materials, isBroken, ItemOverrideList.field_188022_a);
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            List<MaterialId> materialIds = MaterialIdNBT.from(stack).getMaterials();
            boolean broken = ToolDamageUtil.isBroken(stack);
            if (materialIds.isEmpty() && !broken) {
                return originalModel;
            }
            if (broken) {
                return this.brokenCache.computeIfAbsent(materialIds, mats -> this.bakeDynamic((List<MaterialId>)mats, true));
            }
            return this.cleanCache.computeIfAbsent(materialIds, mats -> this.bakeDynamic((List<MaterialId>)mats, false));
        }
    }

    private static class ToolPart {
        private final String name;
        private final int index;
        @Nullable
        private final String broken;

        public boolean hasBroken() {
            return this.broken != null;
        }

        public String getName(boolean isBroken, boolean isLarge) {
            String name = this.name;
            if (isBroken && this.broken != null) {
                name = this.broken;
            }
            if (isLarge) {
                name = "large_" + name;
            }
            return name;
        }

        public static ToolPart read(JsonObject json) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            int index = JSONUtils.func_151203_m((JsonObject)json, (String)"index");
            String broken = null;
            if (json.has("broken")) {
                broken = JSONUtils.func_151200_h((JsonObject)json, (String)"broken");
            }
            return new ToolPart(name, index, broken);
        }

        public ToolPart(String name, int index, @Nullable String broken) {
            this.name = name;
            this.index = index;
            this.broken = broken;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

