/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.block.IncrementalFluidCuboid;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankModel
implements IModelGeometry<TankModel> {
    private static final Logger log = LogManager.getLogger(TankModel.class);
    public static final Loader LOADER = new Loader();
    protected final SimpleBlockModel model;
    @Nullable
    protected final SimpleBlockModel gui;
    protected final IncrementalFluidCuboid fluid;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<RenderMaterial> textures = new HashSet<RenderMaterial>(this.model.getTextures(owner, modelGetter, missingTextureErrors));
        if (this.gui != null) {
            textures.addAll(this.gui.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked;
        IBakedModel bakedGui = baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        if (this.gui != null) {
            bakedGui = this.gui.bakeModel(owner, transform, overrides, spriteGetter, location);
        }
        return new BakedModel<TankModel>(owner, transform, baked, bakedGui, this);
    }

    public TankModel(SimpleBlockModel model, @Nullable SimpleBlockModel gui, IncrementalFluidCuboid fluid) {
        this.model = model;
        this.gui = gui;
        this.fluid = fluid;
    }

    public static class Loader
    implements IModelLoader<TankModel> {
        public void func_195410_a(IResourceManager resourceManager) {
        }

        public TankModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            SimpleBlockModel gui = null;
            if (modelContents.has("gui")) {
                gui = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"gui"));
            }
            IncrementalFluidCuboid fluid = IncrementalFluidCuboid.fromJson(JSONUtils.func_152754_s((JsonObject)modelContents, (String)"fluid"));
            return new TankModel(model, gui, fluid);
        }
    }

    public static class BakedModel<T extends TankModel>
    extends BakedGuiUniqueModel {
        private final IModelConfiguration owner;
        private final IModelTransform originalTransforms;
        protected final T original;
        private final Cache<FluidStack, IBakedModel> cache = CacheBuilder.newBuilder().maximumSize(64L).build();

        protected BakedModel(IModelConfiguration owner, IModelTransform transforms, IBakedModel baked, IBakedModel gui, T original) {
            super(baked, gui);
            this.owner = owner;
            this.originalTransforms = transforms;
            this.original = original;
        }

        public ItemOverrideList func_188617_f() {
            return FluidPartOverride.INSTANCE;
        }

        private IBakedModel getModel(FluidStack stack) {
            HashMap<String, RenderMaterial> textures = new HashMap<String, RenderMaterial>();
            FluidAttributes attributes = stack.getFluid().getAttributes();
            textures.put("fluid", ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getStillTexture(stack)));
            textures.put("flowing_fluid", ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getFlowingTexture(stack)));
            ExtraTextureConfiguration textured = new ExtraTextureConfiguration(this.owner, textures);
            ArrayList elements = Lists.newArrayList((Iterable)((TankModel)this.original).model.getElements());
            BlockPart fluid = ((TankModel)this.original).fluid.getPart(stack.getAmount(), attributes.isGaseous(stack));
            elements.add(fluid);
            Object baked = SimpleBlockModel.bakeDynamic((IModelConfiguration)textured, (List)elements, (IModelTransform)this.originalTransforms);
            if (((TankModel)this.original).gui != null) {
                elements = Lists.newArrayList((Iterable)((TankModel)this.original).gui.getElements());
                elements.add(fluid);
                baked = new BakedGuiUniqueModel((IBakedModel)baked, SimpleBlockModel.bakeDynamic((IModelConfiguration)textured, (List)elements, (IModelTransform)this.originalTransforms));
            }
            return baked;
        }

        private IBakedModel getCachedModel(FluidStack fluid) {
            try {
                return (IBakedModel)this.cache.get((Object)fluid, () -> this.getModel(fluid));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return this;
            }
        }

        private IBakedModel getCachedModel(FluidStack fluid, int capacity) {
            int increments = ((TankModel)this.original).fluid.getIncrements();
            return this.getCachedModel(new FluidStack(fluid.getFluid(), Math.min(fluid.getAmount() * increments / capacity, increments)));
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
            IFluidTank tank;
            if (((Boolean)Config.CLIENT.tankFluidModel.get()).booleanValue() && data.hasProperty(ModelProperties.FLUID_TANK) && (tank = (IFluidTank)data.getData(ModelProperties.FLUID_TANK)) != null && !tank.getFluid().isEmpty()) {
                return this.getCachedModel(tank.getFluid(), tank.getCapacity()).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
            }
            return this.originalModel.getQuads(state, side, rand, data);
        }

        public IncrementalFluidCuboid getFluid() {
            return ((TankModel)this.original).fluid;
        }
    }

    private static class BakedGuiUniqueModel
    extends BakedModelWrapper<IBakedModel> {
        private final IBakedModel gui;

        public BakedGuiUniqueModel(IBakedModel base, IBakedModel gui) {
            super(base);
            this.gui = gui;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                return this.gui.handlePerspective(cameraTransformType, mat);
            }
            return this.originalModel.handlePerspective(cameraTransformType, mat);
        }
    }

    private static class FluidPartOverride
    extends ItemOverrideList {
        public static final FluidPartOverride INSTANCE = new FluidPartOverride();

        private FluidPartOverride() {
        }

        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (stack.func_190926_b() || !stack.func_77942_o()) {
                return model;
            }
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.isEmpty()) {
                return model;
            }
            return ((BakedModel)model).getCachedModel(tank.getFluid(), tank.getCapacity());
        }
    }
}

