/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.smeltery.tileentity.tank.IDisplayFluidListener;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> fluids;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, modelLocation);
        return new Baked(baked, this.model, owner, transform, RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.fluids));
    }

    public FluidTextureModel(SimpleBlockModel model, Set<String> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public FluidTextureModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            ImmutableSet fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", JSONUtils::func_151206_a));
            return new FluidTextureModel(model, (Set<String>)fluids);
        }
    }

    private static class Baked
    extends DynamicBakedWrapper<IBakedModel> {
        private final Map<Fluid, IBakedModel> cache = new HashMap<Fluid, IBakedModel>();
        private final SimpleBlockModel model;
        private final IModelConfiguration owner;
        private final IModelTransform transform;
        private final Set<String> fluids;

        protected Baked(IBakedModel originalModel, SimpleBlockModel model, IModelConfiguration owner, IModelTransform transform, Set<String> fluids) {
            super(originalModel);
            this.model = model;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
        }

        private IBakedModel getRetexturedModel(Fluid fluid) {
            return this.model.bakeDynamic((IModelConfiguration)new RetexturedModel.RetexturedConfiguration(this.owner, this.fluids, fluid.getAttributes().getStillTexture()), this.transform);
        }

        private IBakedModel getCachedModel(Fluid fluid) {
            return this.cache.computeIfAbsent(fluid, this::getRetexturedModel);
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            Fluid fluid = (Fluid)data.getData(IDisplayFluidListener.PROPERTY);
            if (fluid != null && fluid != Fluids.field_204541_a) {
                return this.getCachedModel(fluid).getQuads(state, direction, random, data);
            }
            return this.originalModel.getQuads(state, direction, random, data);
        }
    }
}

