/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.capability.piggyback;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.library.capability.piggyback.CapabilityTinkerPiggyback;
import slimeknights.tconstruct.library.capability.piggyback.ITinkerPiggyback;
import slimeknights.tconstruct.library.capability.piggyback.TinkerPiggybackHandler;

public class TinkerPiggybackSerializer
implements ICapabilitySerializable<CompoundNBT> {
    private final PlayerEntity player;
    private final ITinkerPiggyback piggyback;
    private final LazyOptional<ITinkerPiggyback> providerCap;

    public TinkerPiggybackSerializer(@Nonnull PlayerEntity player) {
        this.player = player;
        this.piggyback = new TinkerPiggybackHandler();
        this.piggyback.setRiddenPlayer(player);
        this.providerCap = LazyOptional.of(() -> this.piggyback);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityTinkerPiggyback.PIGGYBACK) {
            return this.providerCap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        ListNBT riderList = new ListNBT();
        for (Entity entity : this.player.func_184182_bu()) {
            String id = entity.func_70022_Q();
            if (id == null || "".equals(id)) continue;
            CompoundNBT entityTag = new CompoundNBT();
            CompoundNBT entityDataTag = new CompoundNBT();
            entity.func_189511_e(entityDataTag);
            entityDataTag.func_74778_a("id", entity.func_70022_Q());
            entityTag.func_186854_a("Attach", entity.func_184187_bx().func_110124_au());
            entityTag.func_218657_a("Entity", (INBT)entityDataTag);
            riderList.add((Object)entityTag);
        }
        compoundNBT.func_218657_a("riders", (INBT)riderList);
        if (riderList.isEmpty()) {
            return new CompoundNBT();
        }
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT riderList = nbt.func_150295_c("riders", 10);
        HashMap attachedTo = Maps.newHashMap();
        if (this.player.func_130014_f_() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.player.func_130014_f_();
            for (int i = 0; i < riderList.size(); ++i) {
                CompoundNBT entityTag = riderList.func_150305_b(i);
                Entity entity = EntityType.func_220335_a((CompoundNBT)entityTag.func_74775_l("Entity"), (World)serverWorld, p_217885_1_ -> !serverWorld.func_217470_d(p_217885_1_) ? null : p_217885_1_);
                if (entity == null) continue;
                UUID uuid = entityTag.func_186857_a("Attach");
                attachedTo.put(uuid, entity);
            }
        }
    }
}

