/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer.materials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMaterialSectionTransformer
extends SectionTransformer {
    public AbstractMaterialSectionTransformer(String sectionName) {
        super(sectionName);
    }

    protected abstract boolean isValidMaterial(IMaterial var1);

    protected abstract PageContent getPageContent(IMaterial var1, List<ItemStack> var2);

    @Override
    public void transform(BookData book, SectionData sectionData) {
        sectionData.source = BookRepository.DUMMY;
        sectionData.parent = book;
        List materialList = MaterialRegistry.getMaterials().stream().filter(this::isValidMaterial).collect(Collectors.toList());
        if (materialList.isEmpty()) {
            return;
        }
        List<ContentPageIconList> listPages = ContentPageIconList.getPagesNeededForItemCount(materialList.size(), sectionData, book.translate(this.sectionName), (String)book.strings.get(String.format("%s.subtext", this.sectionName)));
        ListIterator<ContentPageIconList> iter = listPages.listIterator();
        ContentPageIconList overview = iter.next();
        for (IMaterial material : materialList) {
            ItemElement icon;
            assert (Minecraft.func_71410_x().field_71441_e != null);
            List recipes = RecipeHelper.getJEIRecipes((RecipeManager)Minecraft.func_71410_x().field_71441_e.func_199532_z(), RecipeTypes.MATERIAL, MaterialRecipe.class).stream().filter(recipe -> recipe.getMaterial() == material).collect(Collectors.toList());
            ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
            for (MaterialRecipe recipe2 : recipes) {
                for (Ingredient ingredient : recipe2.func_192400_c()) {
                    if (ingredient.func_203189_d()) continue;
                    displayStacks.addAll(Arrays.asList(ingredient.func_193365_a()));
                }
            }
            PageData page = this.addPage(sectionData, material.getIdentifier().toString(), "toolmaterial", this.getPageContent(material, displayStacks));
            if (!displayStacks.isEmpty()) {
                icon = new ItemElement(0, 0, 1.0f, displayStacks);
            } else {
                icon = new ImageElement(0, 0, 32, 32, ImageData.MISSING);
                System.out.println("Material with id " + (Object)((Object)material.getIdentifier()) + " has no representation items associated with it");
            }
            while (!overview.addLink((SizedBookElement)icon, (ITextComponent)new TranslationTextComponent(material.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(material.getColor())), page)) {
                overview = iter.next();
            }
        }
    }
}

