/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.tools.TinkerTools;

@OnlyIn(value=Dist.CLIENT)
public class ContentTool
extends TinkerPage {
    public static final transient String ID = "tool";
    public static final transient ImageData IMG_SLOT_1 = ContentModifier.IMG_SLOT_1;
    public static final transient ImageData IMG_SLOT_2 = ContentModifier.IMG_SLOT_2;
    public static final transient ImageData IMG_SLOT_3 = ContentModifier.IMG_SLOT_3;
    public static final transient ImageData IMG_SLOT_4 = ContentModifier.IMG_SLOT_4;
    public static final transient ImageData IMG_SLOT_5 = ContentModifier.IMG_SLOT_5;
    public static final transient ImageData IMG_TABLE = ContentModifier.IMG_TABLE;
    public static final transient ImageData[] IMG_SLOTS = new ImageData[]{IMG_SLOT_1, IMG_SLOT_2, IMG_SLOT_3, IMG_SLOT_4, IMG_SLOT_5};
    public static final transient int[] SLOTS_X = new int[]{3, 21, 39, 12, 30};
    public static final transient int[] SLOTS_Y = new int[]{3, 3, 3, 22, 22};
    public static final transient int[] SLOTS_X_4 = new int[]{3, 21, 3, 21};
    public static final transient int[] SLOTS_Y_4 = new int[]{3, 3, 22, 22};
    private transient ToolCore tool;
    private transient List<ItemStack> parts;
    public TextData[] text = new TextData[0];
    public String[] properties = new String[0];
    @SerializedName(value="tool")
    public String toolName;

    public ContentTool() {
    }

    public ContentTool(ToolCore tool) {
        this.tool = tool;
        this.toolName = tool.getRegistryName().toString();
    }

    public void load() {
        if (this.toolName == null) {
            this.toolName = this.parent.name;
        }
        if (this.tool == null) {
            Item tool = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.toolName));
            this.tool = !(tool instanceof ToolCore) ? (ToolCore)TinkerTools.pickaxe.get() : (ToolCore)tool;
        }
        if (this.parts == null) {
            ImmutableList.Builder partBuilder = ImmutableList.builder();
            List<IToolPart> required = this.tool.getToolDefinition().getRequiredComponents();
            for (int i = 0; i < required.size(); ++i) {
                partBuilder.add((Object)required.get(i).withMaterialForDisplay(ToolBuildHandler.getRenderMaterial(i)));
            }
            this.parts = partBuilder.build();
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean brightSide) {
        this.addTitle(list, this.tool.getLocalizedName().getString());
        int padding = 5;
        int h = BookScreen.PAGE_WIDTH / 3 - 10;
        int y = 16;
        list.add((BookElement)new TextElement(padding, y, BookScreen.PAGE_WIDTH - padding * 2, h, this.text));
        ImageData img = IMG_SLOTS[this.parts.size() - 1];
        int[] slotsX = SLOTS_X;
        int[] slotsY = SLOTS_Y;
        if (this.parts.size() == 4) {
            slotsX = SLOTS_X_4;
            slotsY = SLOTS_Y_4;
        }
        int imgX = BookScreen.PAGE_WIDTH / 2 + 20;
        int imgY = BookScreen.PAGE_HEIGHT / 2 + 30;
        imgX = imgX + 29 - img.width / 2;
        imgY = imgY + 20 - img.height / 2;
        if (this.properties.length > 0) {
            TextData head = new TextData(this.parent.translate("tool.properties"));
            head.underlined = true;
            list.add((BookElement)new TextElement(padding, 30 + h, 86 - padding, BookScreen.PAGE_HEIGHT - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.properties) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new TextElement(padding, 40 + h, BookScreen.PAGE_WIDTH / 2 + 5, BookScreen.PAGE_HEIGHT - h - 20, (Collection)effectData));
        }
        list.add((BookElement)new ImageElement(imgX + (img.width - ContentTool.IMG_TABLE.width) / 2, imgY + 28, -1, -1, IMG_TABLE));
        list.add((BookElement)new ImageElement(imgX, imgY, -1, -1, img, book.appearance.slotColor));
        ItemStack demo = this.tool.buildToolForRendering();
        TinkerItemElement toolItem = new TinkerItemElement(imgX + (img.width - 16) / 2, imgY - 24, 1.0f, demo);
        toolItem.noTooltip = true;
        list.add((BookElement)toolItem);
        list.add((BookElement)new ImageElement(imgX + (img.width - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1, 0xFFFFFF));
        for (int i = 0; i < this.parts.size(); ++i) {
            TinkerItemElement partItem = new TinkerItemElement(imgX + slotsX[i], imgY + slotsY[i], 1.0f, this.parts.get(i));
            partItem.noTooltip = true;
            list.add((BookElement)partItem);
        }
    }
}

