/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@OnlyIn(value=Dist.CLIENT)
public class ContentMaterial
extends TinkerPage {
    public static final String ID = "toolmaterial";
    private transient Lazy<IMaterial> material = Lazy.of(() -> material);
    private transient List<ItemStack> displayStacks;
    @SerializedName(value="material")
    public String materialName;

    public ContentMaterial(IMaterial material, List<ItemStack> displayStacks) {
        this.materialName = material.getIdentifier().toString();
        this.displayStacks = displayStacks;
    }

    public void load() {
        if (this.material == null) {
            this.material = Lazy.of(() -> MaterialRegistry.getMaterial(new MaterialId(this.materialName)));
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        IMaterial material = (IMaterial)this.material.get();
        this.addTitle(list, new TranslationTextComponent(material.getTranslationKey()).getString(), true, material.getColor().func_240742_a_());
        this.addDisplayItems(list, rightSide ? BookScreen.PAGE_WIDTH - 18 : 0, material.getIdentifier());
        int col_margin = 22;
        int top = 15;
        int left = rightSide ? 0 : col_margin;
        int y = top + 10;
        int x = left + 10;
        int w = BookScreen.PAGE_WIDTH / 2 - 10;
        this.addStatsDisplay(x, y, w, list, material, HeadMaterialStats.ID);
        this.addStatsDisplay(x + w, y, w - 10, list, material, HandleMaterialStats.ID);
        this.addStatsDisplay(x, y += 65 + 10 * material.getTraits().size(), w, list, material, ExtraMaterialStats.ID);
        MaterialId id = material.getIdentifier();
        String flavour = (String)this.parent.parent.parent.strings.get(String.format("material.%s.%s.book", id.func_110624_b(), id.func_110623_a()));
        if (flavour != null) {
            TextData flavourData = new TextData("\"" + flavour + "\"");
            flavourData.italic = true;
            list.add((BookElement)new TextElement(x + w, y, w - 16, 60, new TextData[]{flavourData}));
        }
    }

    private void addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, IMaterial material, MaterialStatsId statsId) {
        Optional stats = MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), statsId);
        if (!stats.isPresent()) {
            return;
        }
        List<ModifierEntry> traits = material.getTraits();
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart part : this.getToolParts()) {
            if (part.getStatType() != statsId) continue;
            parts.add(part.withMaterial(material));
        }
        if (parts.size() > 0) {
            TinkerItemElement display = new TinkerItemElement(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
        }
        TextElement name = new TextElement(x + 10, y, w - 10, 10, ((IMaterialStats)stats.get()).getLocalizedName().getString());
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        lineData.addAll(ContentMaterial.getStatLines((IMaterialStats)stats.get()));
        lineData.addAll(ContentMaterial.getTraitLines(traits, material));
        list.add((BookElement)new TextComponentElement(x, y, w, BookScreen.PAGE_HEIGHT, (Collection)lineData));
    }

    public static List<TextComponentData> getStatLines(IMaterialStats stats) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextComponentData text = new TextComponentData(stats.getLocalizedInfo().get(i));
            text.tooltips = stats.getLocalizedDescriptions().get(i).getString().isEmpty() ? null : new ITextComponent[]{stats.getLocalizedDescriptions().get(i)};
            lineData.add(text);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    public static List<TextComponentData> getTraitLines(List<ModifierEntry> traits, IMaterial material) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (ModifierEntry trait : traits) {
            Modifier mod = trait.getModifier();
            TextComponentData textComponentData = new TextComponentData(mod.getDisplayName());
            List<ITextComponent> textComponents = mod.getDescriptionList();
            ArrayList<IFormattableTextComponent> formatted = new ArrayList<IFormattableTextComponent>();
            for (int index = 0; index < textComponents.size(); ++index) {
                ITextComponent textComponent = textComponents.get(index);
                if (index == 0) {
                    formatted.add(((IFormattableTextComponent)textComponent).func_240700_a_(style -> style.func_240718_a_(material.getColor())));
                    continue;
                }
                formatted.add((IFormattableTextComponent)textComponent);
            }
            textComponentData.tooltips = formatted.toArray(new ITextComponent[0]);
            textComponentData.text = textComponentData.text.func_230532_e_().func_240699_a_(TextFormatting.DARK_GRAY).func_240699_a_(TextFormatting.UNDERLINE);
            lineData.add(textComponentData);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private void addDisplayItems(ArrayList<BookElement> list, int x, MaterialId materialId) {
        ArrayList displayTools = Lists.newArrayList();
        if (!this.displayStacks.isEmpty()) {
            displayTools.add(new TinkerItemElement(0, 0, 1.0f, this.displayStacks));
        } else {
            System.out.println("Material with id " + (Object)((Object)materialId) + " has no representation items associated with it");
        }
        if (((IMaterial)this.material.get()).isCraftable()) {
            ItemStack partBuilder = new ItemStack((IItemProvider)TinkerTables.partBuilder.func_199767_j());
            TinkerItemElement elementItem = new TinkerItemElement(partBuilder);
            elementItem.tooltip = ImmutableList.of((Object)new StringTextComponent(this.parent.translate("material.craft_partbuilder")));
            displayTools.add(elementItem);
        }
        if (((IMaterial)this.material.get()).getFluid() != Fluids.field_204541_a) {
            ItemStack castingBasin = new ItemStack((IItemProvider)TinkerSmeltery.castingBasin.func_199767_j());
            ItemStack castingTable = new ItemStack((IItemProvider)TinkerSmeltery.castingTable.func_199767_j());
            ItemStackList stacks = ItemStackList.of((ItemStack[])new ItemStack[]{castingBasin, castingTable});
            TinkerItemElement elementItem = new TinkerItemElement(0, 0, 1.0f, (Collection<ItemStack>)stacks);
            String text = this.parent.translate("material.craft_casting");
            Fluid fluid = ((IMaterial)this.material.get()).getFluid();
            elementItem.tooltip = ImmutableList.of((Object)new StringTextComponent(text).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("fluid." + Objects.requireNonNull(fluid.getRegistryName()).func_110624_b() + "." + Objects.requireNonNull(fluid.getRegistryName()).func_110623_a())));
            displayTools.add(elementItem);
        }
        int y = 10;
        for (Item tool : TinkerTags.Items.MULTIPART_TOOL.func_230236_b_()) {
            if (!(tool instanceof ToolCore)) continue;
            List<IToolPart> requirements = ((ToolCore)tool).getToolDefinition().getRequiredComponents();
            ArrayList<IMaterial> materials = new ArrayList<IMaterial>(requirements.size());
            for (int i = 0; i < requirements.size(); ++i) {
                materials.add(i, MaterialRegistry.getInstance().getMaterial(materialId));
            }
            ItemStack display = ToolBuildHandler.buildItemFromMaterials((ToolCore)tool, materials);
            displayTools.add(new TinkerItemElement(display));
            if (displayTools.size() != 9) continue;
            break;
        }
        if (!displayTools.isEmpty()) {
            for (ItemElement element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }

    public List<IToolPart> getToolParts() {
        return TinkerTags.Items.TOOL_PARTS.func_230236_b_().stream().filter(item -> item instanceof IToolPart).map(item -> (IToolPart)item).collect(Collectors.toList());
    }
}

