/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book;

import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.book.content.ContentImageText2;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.content.ContentTool;
import slimeknights.tconstruct.library.book.sectiontransformer.ModifierSectionTransformer;
import slimeknights.tconstruct.library.book.sectiontransformer.ToolSectionTransformer;
import slimeknights.tconstruct.library.book.sectiontransformer.materials.MaterialSectionTransformer;
import slimeknights.tconstruct.library.book.sectiontransformer.materials.TieredMaterialSectionTransformer;
import slimeknights.tconstruct.shared.item.TinkerBookItem;

public class TinkerBook
extends BookData {
    private static final ResourceLocation MATERIALS_BOOK_ID = Util.getResource("materials_and_you");
    private static final ResourceLocation MIGHTY_SMELTING_ID = Util.getResource("mighty_smelting");
    private static final ResourceLocation PUNY_SMELTING_ID = Util.getResource("puny_smelting");
    private static final ResourceLocation TINKERS_GADGETRY_ID = Util.getResource("tinkers_gadgetry");
    public static final BookData MATERIALS_AND_YOU = BookLoader.registerBook((String)MATERIALS_BOOK_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData PUNY_SMELTING = BookLoader.registerBook((String)MIGHTY_SMELTING_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData MIGHTY_SMELTING = BookLoader.registerBook((String)MIGHTY_SMELTING_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData TINKERS_GADGETRY = BookLoader.registerBook((String)TINKERS_GADGETRY_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);

    public TinkerBook() {
        super(new BookRepository[0]);
    }

    public static void initBook() {
        BookLoader.registerPageType((String)"imageText2", ContentImageText2.class);
        BookLoader.registerPageType((String)"toolmaterial", ContentMaterial.class);
        BookLoader.registerPageType((String)"tool", ContentTool.class);
        BookLoader.registerPageType((String)"modifier", ContentModifier.class);
        TinkerBook.addData(MATERIALS_AND_YOU, MATERIALS_BOOK_ID);
        TinkerBook.addData(PUNY_SMELTING, PUNY_SMELTING_ID);
        TinkerBook.addData(MIGHTY_SMELTING, MIGHTY_SMELTING_ID);
        TinkerBook.addData(TINKERS_GADGETRY, TINKERS_GADGETRY_ID);
    }

    private static void addData(BookData book, ResourceLocation id) {
        book.addRepository((BookRepository)new FileRepository(id.func_110624_b() + ":book/" + id.func_110623_a()));
        book.addTransformer((BookTransformer)new MaterialSectionTransformer());
        book.addTransformer((BookTransformer)new ToolSectionTransformer());
        book.addTransformer((BookTransformer)new ModifierSectionTransformer());
        book.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_one_materials", 1));
        book.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_two_materials", 2));
        book.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_three_materials", 3));
        book.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_four_materials", 4));
        book.addTransformer(BookTransformer.indexTranformer());
    }

    public static BookData getBook(TinkerBookItem.BookType bookType) {
        switch (bookType) {
            case MATERIALS_AND_YOU: {
                return MATERIALS_AND_YOU;
            }
            case PUNY_SMELTING: {
                return PUNY_SMELTING;
            }
            case MIGHTY_SMELTING: {
                return MIGHTY_SMELTING;
            }
            case TINKERS_GADGETRY: {
                return TINKERS_GADGETRY;
            }
        }
        return MATERIALS_AND_YOU;
    }
}

