/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.collect.ImmutableMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class Util {
    public static final String MODID = "tconstruct";
    public static final String RESOURCE = "tconstruct".toLowerCase(Locale.US);
    public static final Marker TCONSTRUCT = MarkerManager.getMarker((String)"TCONSTRUCT");
    public static final DecimalFormat df = new DecimalFormat("#,###,###.##", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat dfPercent = new DecimalFormat("#%");
    public static final DecimalFormat dfMultiplier = new DecimalFormat("#.##x");
    public static final DecimalFormat dfPercentBoost = new DecimalFormat("#%");
    private static ImmutableMap<Vector3i, Direction> offsetMap;

    public static Logger getLogger(String type) {
        String log = MODID;
        return LogManager.getLogger((String)(log + "-" + type));
    }

    public static Optional<String> getCurrentlyActiveExternalMod() {
        return Optional.ofNullable(ModLoadingContext.get().getActiveContainer().getModId()).filter(activeModId -> !MODID.equals(activeModId));
    }

    public static String sanitizeLocalizationString(String string) {
        return string.toLowerCase(Locale.US).replaceAll(" ", "").trim();
    }

    public static String resource(String res) {
        return String.format("%s:%s", RESOURCE, res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation(RESOURCE, res);
    }

    public static ModelResourceLocation getModelResource(String res, String variant) {
        return new ModelResourceLocation(Util.resource(res), variant);
    }

    public static ResourceLocation getModifierResource(String res) {
        return Util.getResource("models/item/modifiers/" + res);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", RESOURCE, name.toLowerCase(Locale.US));
    }

    public static boolean canTranslate(String key) {
        return !ForgeI18n.getPattern((String)key).equals(key);
    }

    public static String makeTranslationKey(String base, String name) {
        return net.minecraft.util.Util.func_200697_a((String)base, (ResourceLocation)Util.getResource(name));
    }

    public static IFormattableTextComponent makeTranslation(String base, String name) {
        return new TranslationTextComponent(Util.makeTranslationKey(base, name));
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static String translate(String key, Object ... pars) {
        return I18n.func_135052_a((String)I18n.func_135052_a((String)String.format(key, pars), (Object[])new Object[0]).trim(), (Object[])new Object[0]).trim();
    }

    public static String translateFormatted(String key, Object ... pars) {
        return I18n.func_135052_a((String)I18n.func_135052_a((String)key, (Object[])pars).trim(), (Object[])new Object[0]).trim();
    }

    public static boolean isCtrlKeyDown() {
        boolean isCtrlKeyDown;
        boolean bl = isCtrlKeyDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)345);
        if (!isCtrlKeyDown && Minecraft.field_142025_a) {
            isCtrlKeyDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)342) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)346);
        }
        return isCtrlKeyDown;
    }

    public static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    public static int enumChatFormattingToColor(TextFormatting color) {
        int i = color.func_175746_b();
        int j = (i >> 3 & 1) * 85;
        int k = (i >> 2 & 1) * 170 + j;
        int l = (i >> 1 & 1) * 170 + j;
        int i1 = (i >> 0 & 1) * 170 + j;
        if (i == 6) {
            k += 85;
        }
        if (i >= 16) {
            k /= 4;
            l /= 4;
            i1 /= 4;
        }
        return (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
    }

    public static Direction facingFromOffset(BlockPos offset) {
        return (Direction)offsetMap.get((Object)offset);
    }

    public static Direction facingFromNeighbor(BlockPos pos, BlockPos neighbor) {
        return Util.facingFromOffset(neighbor.func_177973_b((Vector3i)pos));
    }

    public static boolean clickedAABB(AxisAlignedBB aabb, float hitX, float hitY, float hitZ) {
        return aabb.field_72340_a <= (double)hitX && (double)hitX <= aabb.field_72336_d && aabb.field_72338_b <= (double)hitY && (double)hitY <= aabb.field_72337_e && aabb.field_72339_c <= (double)hitZ && (double)hitZ <= aabb.field_72334_f;
    }

    public static String toIndentedStringList(Collection<?> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", ""));
    }

    public static int sign(int value) {
        if (value == 0) {
            return 0;
        }
        return value > 0 ? 1 : -1;
    }

    static {
        dfPercentBoost.setPositivePrefix("+");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Direction facing : Direction.values()) {
            builder.put((Object)facing.func_176730_m(), (Object)facing);
        }
        offsetMap = builder.build();
    }
}

