/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import java.util.IdentityHashMap;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;

public class SlimeBounceHandler
implements Consumer<LivingEvent.LivingUpdateEvent> {
    private static final IdentityHashMap<Entity, SlimeBounceHandler> bouncingEntities = new IdentityHashMap();
    public final LivingEntity entityLiving;
    private int timer;
    private boolean wasInAir;
    private double bounce;
    private int bounceTick;
    private double lastMovX;
    private double lastMovZ;

    public SlimeBounceHandler(LivingEntity entityLiving, double bounce) {
        this.entityLiving = entityLiving;
        this.timer = 0;
        this.wasInAir = false;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entityLiving.field_70173_aa + 1 : 0;
        bouncingEntities.put((Entity)entityLiving, this);
    }

    @Override
    public void accept(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == this.entityLiving && !this.entityLiving.func_184613_cA()) {
            if (this.entityLiving.field_70173_aa == this.bounceTick) {
                Vector3d vec3d = this.entityLiving.func_213322_ci();
                this.entityLiving.func_213293_j(vec3d.field_72450_a, this.bounce, vec3d.field_72449_c);
                this.bounceTick = 0;
            }
            if (!(this.entityLiving.func_233570_aj_() || this.entityLiving.field_70173_aa == this.bounceTick || this.lastMovX == this.entityLiving.func_213322_ci().field_72450_a && this.lastMovZ == this.entityLiving.func_213322_ci().field_72449_c)) {
                double f = 0.935;
                Vector3d vec3d = this.entityLiving.func_213322_ci();
                this.entityLiving.func_213293_j(vec3d.field_72450_a / f, vec3d.field_72448_b, vec3d.field_72449_c / f);
                this.entityLiving.field_70160_al = true;
                this.lastMovX = this.entityLiving.func_213322_ci().field_72450_a;
                this.lastMovZ = this.entityLiving.func_213322_ci().field_72449_c;
            }
            if (this.wasInAir && this.entityLiving.func_233570_aj_()) {
                if (this.timer == 0) {
                    this.timer = this.entityLiving.field_70173_aa;
                } else if (this.entityLiving.field_70173_aa - this.timer > 5) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    bouncingEntities.remove(this.entityLiving);
                }
            } else {
                this.timer = 0;
                this.wasInAir = true;
            }
        }
    }

    public static void addBounceHandler(LivingEntity entity) {
        SlimeBounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(LivingEntity entity, double bounce) {
        if (entity instanceof FakePlayer) {
            return;
        }
        SlimeBounceHandler handler = bouncingEntities.get(entity);
        if (handler == null) {
            MinecraftForge.EVENT_BUS.addListener((Consumer)new SlimeBounceHandler(entity, bounce));
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.field_70173_aa + 1;
        }
    }
}

