/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tconstruct.library.IMaterialRegistry;
import slimeknights.tconstruct.library.exception.TinkerAPIMaterialException;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.MaterialManager;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.library.traits.MaterialTraitsManager;

public class MaterialRegistryImpl
implements IMaterialRegistry {
    private final MaterialManager materialManager;
    private final MaterialStatsManager materialStatsManager;
    private final MaterialTraitsManager materialTraitsManager;
    private final List<Runnable> onMaterialReload = new ArrayList<Runnable>();
    private Map<MaterialStatsId, IMaterialStats> materialStatDefaults = new HashMap<MaterialStatsId, IMaterialStats>();

    protected MaterialRegistryImpl(MaterialManager materialManager, MaterialStatsManager materialStatsManager, MaterialTraitsManager materialTraitsManager) {
        this.materialManager = materialManager;
        this.materialStatsManager = materialStatsManager;
        this.materialTraitsManager = materialTraitsManager;
        MinecraftForge.EVENT_BUS.addListener(this::handleLogin);
    }

    @Override
    public IMaterial getMaterial(MaterialId id) {
        return this.materialManager.getMaterial(id).orElse(IMaterial.UNKNOWN);
    }

    @Override
    public IMaterial getMaterial(Fluid fluid) {
        return this.materialManager.getMaterial(fluid).orElse(IMaterial.UNKNOWN);
    }

    @Override
    public Collection<IMaterial> getMaterials() {
        return this.materialManager.getAllMaterials();
    }

    @Override
    public <T extends IMaterialStats> Optional<T> getMaterialStats(MaterialId materialId, MaterialStatsId statsId) {
        return this.materialStatsManager.getStats(materialId, statsId);
    }

    @Override
    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialStatsManager.getAllStats(materialId);
    }

    @Override
    public <T extends IMaterialStats> T getDefaultStats(MaterialStatsId statsId) {
        return (T)this.materialStatDefaults.get((Object)statsId);
    }

    @Override
    public <T extends IMaterialStats> void registerStatType(T defaultStats, Class<T> clazz) {
        MaterialStatsId statsId = defaultStats.getIdentifier();
        if (this.materialStatDefaults.containsKey((Object)statsId)) {
            throw TinkerAPIMaterialException.materialStatsTypeRegisteredTwice(statsId);
        }
        this.materialStatsManager.registerMaterialStat(statsId, clazz);
        this.materialStatDefaults.put(statsId, defaultStats);
    }

    private void handleLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            TinkerNetwork network = TinkerNetwork.getInstance();
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> serverPlayer);
            network.send(target, this.materialManager.getUpdatePacket());
            network.send(target, this.materialStatsManager.getUpdatePacket());
        }
    }

    @Override
    public void addMaterialSyncListener(Runnable listener) {
        this.onMaterialReload.add(listener);
    }

    @Override
    public void onMaterialSync() {
        for (Runnable runnable : this.onMaterialReload) {
            runnable.run();
        }
    }
}

