/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import net.minecraft.fluid.Fluid;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.IMaterialRegistry;
import slimeknights.tconstruct.library.MaterialRegistryImpl;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.MaterialManager;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.library.network.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.network.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.traits.MaterialTraitsManager;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MaterialRegistry {
    protected static MaterialRegistry INSTANCE;
    private final MaterialManager materialManager;
    private final MaterialStatsManager materialStatsManager;
    private final MaterialTraitsManager materialTraitsManager;
    private final IMaterialRegistry registry;

    public static IMaterialRegistry getInstance() {
        return MaterialRegistry.INSTANCE.registry;
    }

    public static void init() {
        INSTANCE = new MaterialRegistry();
    }

    public static boolean initialized() {
        return INSTANCE != null;
    }

    @SubscribeEvent
    static void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)MaterialRegistry.INSTANCE.materialManager);
        event.addListener((IFutureReloadListener)MaterialRegistry.INSTANCE.materialStatsManager);
        event.addListener((IFutureReloadListener)MaterialRegistry.INSTANCE.materialTraitsManager);
    }

    public MaterialRegistry() {
        this.materialManager = new MaterialManager();
        this.materialStatsManager = new MaterialStatsManager();
        this.materialTraitsManager = new MaterialTraitsManager();
        this.registry = new MaterialRegistryImpl(this.materialManager, this.materialStatsManager, this.materialTraitsManager);
        this.registry.registerStatType(HeadMaterialStats.DEFAULT, HeadMaterialStats.class);
        this.registry.registerStatType(HandleMaterialStats.DEFAULT, HandleMaterialStats.class);
        this.registry.registerStatType(ExtraMaterialStats.DEFAULT, ExtraMaterialStats.class);
    }

    @VisibleForTesting
    MaterialRegistry(IMaterialRegistry registry) {
        this.registry = registry;
        this.materialManager = null;
        this.materialStatsManager = null;
        this.materialTraitsManager = null;
    }

    public static void updateMaterialsFromServer(UpdateMaterialsPacket packet) {
        MaterialRegistry.INSTANCE.materialManager.updateMaterialsFromServer(packet.getMaterials());
    }

    public static void updateMaterialStatsFromServer(UpdateMaterialStatsPacket packet) {
        MaterialRegistry.INSTANCE.materialStatsManager.updateMaterialStatsFromServer(packet.getMaterialToStats());
        MaterialRegistry.INSTANCE.registry.onMaterialSync();
    }

    public static Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        return MaterialRegistry.INSTANCE.materialStatsManager.getClassForStat(id);
    }

    public static IMaterial getMaterial(MaterialId id) {
        return MaterialRegistry.INSTANCE.registry.getMaterial(id);
    }

    public static IMaterial getMaterial(Fluid fluid) {
        return MaterialRegistry.INSTANCE.registry.getMaterial(fluid);
    }

    public static Collection<IMaterial> getMaterials() {
        return MaterialRegistry.INSTANCE.registry.getMaterials();
    }
}

