/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.capability.piggyback.CapabilityTinkerPiggyback;
import slimeknights.tconstruct.library.capability.piggyback.ITinkerPiggyback;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.effect.TinkerEffect;
import slimeknights.tconstruct.library.network.TinkerNetwork;

public class PiggyBackPackItem
extends TooltipItem {
    private static final int MAX_ENTITY_STACK = 3;

    public PiggyBackPackItem(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ItemStack chestArmor = playerIn.func_184582_a(EquipmentSlotType.CHEST);
        if (chestArmor.func_77973_b() != this && playerIn.field_71071_by.func_70447_i() == -1) {
            return ActionResultType.PASS;
        }
        if (this.pickupEntity(playerIn, (Entity)target)) {
            if (chestArmor.func_77973_b() != this) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)chestArmor);
                chestArmor = ItemStack.field_190927_a;
            }
            if (chestArmor.func_190926_b()) {
                playerIn.func_184201_a(EquipmentSlotType.CHEST, stack.func_77979_a(1));
            } else if (chestArmor.func_190916_E() < this.getEntitiesCarriedCount((LivingEntity)playerIn)) {
                stack.func_77979_a(1);
                chestArmor.func_190917_f(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean pickupEntity(PlayerEntity player, Entity target) {
        int count;
        if (player.func_130014_f_().field_72995_K || TinkerTags.EntityTypes.PIGGYBACKPACK_BLACKLIST.func_230235_a_((Object)target.func_200600_R())) {
            return false;
        }
        if (target.func_184187_bx() == player || player.func_184187_bx() == target) {
            return false;
        }
        PlayerEntity toRide = player;
        for (count = 0; toRide.func_184207_aI() && count < 3; ++count) {
            toRide = (Entity)toRide.func_184188_bt().get(0);
            if (!(toRide instanceof PlayerEntity) || !(target instanceof PlayerEntity)) continue;
            return false;
        }
        if (!toRide.func_184207_aI() && count < 3 && target.func_184205_a((Entity)toRide, true)) {
            if (player instanceof ServerPlayerEntity) {
                TinkerNetwork.getInstance().sendVanillaPacket((Entity)player, (IPacket<?>)new SSetPassengersPacket((Entity)player));
            }
            return true;
        }
        return false;
    }

    private int getEntitiesCarriedCount(LivingEntity player) {
        int count = 0;
        LivingEntity ridden = player;
        while (ridden.func_184207_aI()) {
            ++count;
            ridden = (Entity)ridden.func_184188_bt().get(0);
        }
        return count;
    }

    public void matchCarriedEntitiesToCount(LivingEntity player, int maxCount) {
        int count = 0;
        LivingEntity ridden = player;
        while (ridden.func_184207_aI()) {
            ridden = (Entity)ridden.func_184188_bt().get(0);
            if (++count <= maxCount) continue;
            ridden.func_184210_p();
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LivingEntity livingEntity;
        if (entityIn instanceof LivingEntity && (livingEntity = (LivingEntity)entityIn).func_184582_a(EquipmentSlotType.CHEST) == stack && entityIn.func_184207_aI()) {
            int amplifier = this.getEntitiesCarriedCount(livingEntity) - 1;
            livingEntity.func_195064_c(new EffectInstance((Effect)TinkerGadgets.carryEffect.get(), 2, amplifier, true, false));
        }
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static class CarryPotionEffect
    extends TinkerEffect {
        static final String UUID = "ff4de63a-2b24-11e6-b67b-9e71128cae77";

        public CarryPotionEffect() {
            super(EffectType.NEUTRAL, true);
            this.func_220304_a(Attributes.field_233821_d_, UUID, -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }

        public boolean func_76397_a(int duration, int amplifier) {
            return true;
        }

        public void func_76394_a(@Nonnull LivingEntity livingEntityIn, int p_76394_2_) {
            ItemStack chestArmor = livingEntityIn.func_184582_a(EquipmentSlotType.CHEST);
            if (chestArmor.func_190926_b() || chestArmor.func_77973_b() != TinkerGadgets.piggyBackpack.get()) {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, 0);
            } else {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, chestArmor.func_190916_E());
                if (!livingEntityIn.func_130014_f_().field_72995_K) {
                    livingEntityIn.getCapability(CapabilityTinkerPiggyback.PIGGYBACK, null).ifPresent(ITinkerPiggyback::updatePassengers);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack matrices, int x, int y, float z) {
            this.renderHUDEffect(effect, (AbstractGui)gui, matrices, x, y, z, 1.0f);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderHUDEffect(EffectInstance effect, AbstractGui gui, MatrixStack matrices, int x, int y, float z, float alpha) {
            ElementScreen element;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Icons.ICONS);
            switch (effect.func_76458_c()) {
                case 0: {
                    element = Icons.PIGGYBACK_1;
                    break;
                }
                case 1: {
                    element = Icons.PIGGYBACK_2;
                    break;
                }
                default: {
                    element = Icons.PIGGYBACK_3;
                }
            }
            element.draw(matrices, x + 6, y + 7);
        }
    }
}

