/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;

public class FancyItemFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(FancyItemFrameEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String TAG_VARIANT = "Variant";

    public FancyItemFrameEntity(EntityType<? extends FancyItemFrameEntity> type, World world) {
        super(type, world);
    }

    public FancyItemFrameEntity(World worldIn, BlockPos blockPos, Direction face, int variant) {
        super((EntityType)TinkerGadgets.itemFrameEntity.get(), worldIn);
        this.field_174861_a = blockPos;
        this.func_174859_a(face);
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public FrameType getFrameType() {
        return FrameType.byId(this.getVariantIndex());
    }

    public int getVariantIndex() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Nullable
    public ItemEntity func_70099_a(@Nonnull ItemStack stack, float offset) {
        if (stack.func_77973_b() == Items.field_151160_bD) {
            stack = new ItemStack((IItemProvider)FrameType.getFrameFromType(this.getFrameType()));
        }
        return super.func_70099_a(stack, offset);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack((IItemProvider)FrameType.getFrameFromType(this.getFrameType()));
        }
        return held.func_77946_l();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(TAG_VARIANT, this.getVariantIndex());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(VARIANT, (Object)compound.func_74762_e(TAG_VARIANT));
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.getVariantIndex());
        buffer.func_179255_a(this.field_174861_a);
        buffer.func_150787_b(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)buffer.func_150792_a());
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(Direction.func_82600_a((int)buffer.func_150792_a()));
    }

    private static void removeClickEvents(ITextComponent text) {
        if (text instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)text).func_240700_a_(p_213318_0_ -> p_213318_0_.func_240715_a_(null)).func_150253_a().forEach(FancyItemFrameEntity::removeClickEvents);
        }
    }

    protected ITextComponent func_225513_by_() {
        return new TranslationTextComponent(FrameType.getFrameFromType(this.getFrameType()).func_77658_a());
    }
}

