/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.tconstruct.gadgets.entity.EFLNExplosion;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.tools.common.network.EntityMovementChangePacket;

public class Exploder {
    public final double r;
    private final double rr;
    public final int dist;
    private final double explosionStrength;
    private final int blocksPerIteration;
    public final int x;
    public final int y;
    public final int z;
    public final World world;
    private final Entity exploder;
    private final EFLNExplosion explosion;
    private int currentRadius;
    private int curX;
    private int curY;
    private int curZ;
    private List<ItemStack> droppedItems;

    public Exploder(World world, EFLNExplosion explosion, Entity exploder, BlockPos location, double r, double explosionStrength, int blocksPerIteration) {
        this.r = r;
        this.world = world;
        this.explosion = explosion;
        this.exploder = exploder;
        this.rr = r * r;
        this.dist = (int)r + 1;
        this.explosionStrength = explosionStrength;
        this.blocksPerIteration = blocksPerIteration;
        this.currentRadius = 0;
        this.x = location.func_177958_n();
        this.y = location.func_177956_o();
        this.z = location.func_177952_p();
        this.curX = 0;
        this.curY = 0;
        this.curZ = 0;
        this.droppedItems = Lists.newArrayList();
    }

    public static void startExplosion(World world, EFLNExplosion explosion, Entity entity, BlockPos location, double r, double explosionStrength) {
        Exploder exploder = new Exploder(world, explosion, entity, location, r, explosionStrength, Math.max(50, (int)(r * r * r / 10.0)));
        exploder.handleEntities();
        world.func_184133_a(null, location, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        MinecraftForge.EVENT_BUS.register((Object)exploder);
    }

    private void handleEntities() {
        Predicate<Entity> predicate = entity -> entity != null && !entity.func_180427_aV() && EntityPredicates.field_180132_d.test(entity) && EntityPredicates.field_94557_a.test(entity) && entity.func_213303_ch().func_186679_c((double)this.x, (double)this.y, (double)this.z) <= this.r * this.r;
        List list = this.world.func_175674_a(this.exploder, new AxisAlignedBB((double)this.x - this.r - 1.0, (double)this.y - this.r - 1.0, (double)this.z - this.r - 1.0, (double)this.x + this.r + 1.0, (double)this.y + this.r + 1.0, (double)this.z + this.r + 1.0), predicate);
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, (List)list, (double)(this.r * 2.0));
        for (Entity entity2 : list) {
            Vector3d dir = entity2.func_213303_ch().func_178788_d(this.exploder.func_213303_ch().func_72441_c(0.0, -this.r / 2.0, 0.0));
            double str = (this.r - dir.func_72433_c()) / this.r;
            str = Math.max(0.3, str);
            dir = dir.func_72432_b();
            dir = dir.func_186678_a(this.explosionStrength * str * 0.3);
            entity2.func_70024_g(dir.field_72450_a, dir.field_72448_b + 0.5, dir.field_72449_c);
            entity2.func_70097_a(DamageSource.func_94539_a((Explosion)this.explosion), (float)(str * this.explosionStrength));
            if (!(entity2 instanceof ServerPlayerEntity)) continue;
            TinkerNetwork.getInstance().sendTo(new EntityMovementChangePacket(entity2), (ServerPlayerEntity)entity2);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.world == this.world && event.phase == TickEvent.Phase.END && !this.iteration()) {
            this.finish();
        }
    }

    private void finish() {
        int d = (int)this.r / 2;
        BlockPos pos = new BlockPos(this.x - d, this.y - d, this.z - d);
        Random random = new Random();
        ArrayList aggregatedDrops = Lists.newArrayList();
        for (ItemStack drop : this.droppedItems) {
            boolean notInList = true;
            for (ItemStack stack : aggregatedDrops) {
                if (!ItemStack.func_179545_c((ItemStack)drop, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)drop, (ItemStack)stack)) continue;
                stack.func_190917_f(drop.func_190916_E());
                notInList = false;
                break;
            }
            if (!notInList) continue;
            aggregatedDrops.add(drop);
        }
        for (ItemStack drop : aggregatedDrops) {
            ItemStack dropItemstack;
            int stacksize = drop.func_190916_E();
            do {
                BlockPos spawnPos = pos.func_177982_a(random.nextInt((int)this.r), random.nextInt((int)this.r), random.nextInt((int)this.r));
                dropItemstack = drop.func_77946_l();
                dropItemstack.func_190920_e(Math.min(stacksize, 64));
                Block.func_180635_a((World)this.world, (BlockPos)spawnPos, (ItemStack)dropItemstack);
            } while ((stacksize -= dropItemstack.func_190916_E()) > 0);
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private boolean iteration() {
        int count = 0;
        this.explosion.func_180342_d();
        while (count < this.blocksPerIteration && this.currentRadius < (int)this.r + 1) {
            double d = this.curX * this.curX + this.curY * this.curY + this.curZ * this.curZ;
            if (d <= this.rr) {
                BlockPos blockpos = new BlockPos(this.x + this.curX, this.y + this.curY, this.z + this.curZ);
                BlockState blockState = this.world.func_180495_p(blockpos);
                FluidState ifluidstate = this.world.func_204610_c(blockpos);
                if (!blockState.isAir((IBlockReader)this.world, blockpos) || !ifluidstate.func_206888_e()) {
                    double f = this.explosionStrength * (1.0 - d / this.rr);
                    float f2 = Math.max(blockState.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this.explosion), ifluidstate.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this.explosion));
                    if (this.exploder != null) {
                        f2 = this.exploder.func_180428_a((Explosion)this.explosion, (IBlockReader)this.world, blockpos, blockState, ifluidstate, f2);
                    }
                    if ((f -= (double)((f2 + 0.3f) * 0.3f)) > 0.0 && (this.exploder == null || this.exploder.func_174816_a((Explosion)this.explosion, (IBlockReader)this.world, blockpos, blockState, (float)f))) {
                        ++count;
                        this.explosion.addAffectedBlock(blockpos);
                    }
                }
            }
            this.step();
        }
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, Collections.emptyList(), (double)(this.r * 2.0));
        this.explosion.func_180343_e().forEach(this::explodeBlock);
        return count == this.blocksPerIteration;
    }

    private void step() {
        if (++this.curX > this.currentRadius) {
            this.curX = -this.currentRadius;
            if (++this.curZ > this.currentRadius) {
                this.curZ = -this.currentRadius;
                if (--this.curY < -this.currentRadius) {
                    ++this.currentRadius;
                    this.curX = this.curZ = -this.currentRadius;
                    this.curY = this.currentRadius;
                }
            }
        }
        if (this.curY != -this.currentRadius && this.curY != this.currentRadius && this.curZ != -this.currentRadius && this.curZ != this.currentRadius && this.curX > -this.currentRadius) {
            this.curX = this.currentRadius;
        }
    }

    private void explodeBlock(BlockPos blockpos) {
        BlockState blockstate = this.world.func_180495_p(blockpos);
        if (!this.world.field_72995_K && blockstate.canDropFromExplosion((IBlockReader)this.world, blockpos, (Explosion)this.explosion)) {
            TileEntity tileentity = blockstate.hasTileEntity() ? this.world.func_175625_s(blockpos) : null;
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity);
            this.droppedItems.addAll(blockstate.func_215693_a(builder));
        }
        if (this.world instanceof ServerWorld) {
            for (ServerPlayerEntity serverplayerentity : ((ServerWorld)this.world).func_217369_A()) {
                ((ServerWorld)this.world).func_195600_a(serverplayerentity, (IParticleData)ParticleTypes.field_197598_I, true, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0);
                ((ServerWorld)this.world).func_195600_a(serverplayerentity, (IParticleData)ParticleTypes.field_197601_L, true, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        blockstate.onBlockExploded(this.world, blockpos, (Explosion)this.explosion);
    }
}

